/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.core.PTAScene;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.parm.ctxcons.ObjCtxConstructor;
import qilin.parm.heapabst.AllocSiteAbstractor;
import qilin.parm.heapabst.HeuristicAbstractor;
import qilin.parm.select.HeuristicSelector;
import qilin.parm.select.PartialVarSelector;
import qilin.parm.select.PipelineSelector;
import qilin.pta.PTAConfig;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import qilin.util.queue.QueueReader;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;

public abstract class PartialObjSensPTA
extends StagedPTA {
    protected Set<Object> csnodes = new HashSet<Object>();
    protected Set<SootMethod> csmethods = new HashSet<SootMethod>();
    protected PAG prePAG;
    Set<SootMethod> PCSM = new HashSet<SootMethod>();
    Set<SootMethod> CSM = new HashSet<SootMethod>();

    public PartialObjSensPTA(PTAScene scene, int ctxLen) {
        super(scene);
        this.ctxCons = new ObjCtxConstructor();
        PartialVarSelector us = new PartialVarSelector(ctxLen, ctxLen - 1, this.csnodes, this.csmethods);
        this.ctxSel = PTAConfig.v().getPtaConfig().enforceEmptyCtxForIgnoreTypes ? new PipelineSelector(new HeuristicSelector(this.getView()), us) : us;
        this.heapAbst = PTAConfig.v().getPtaConfig().mergeHeap ? new HeuristicAbstractor(this.pag) : new AllocSiteAbstractor();
        this.prePTA = new Spark(scene);
        this.prePAG = this.prePTA.getPag();
    }

    @Override
    protected void preAnalysis() {
        Stopwatch sparkTimer = Stopwatch.newAndStart("Spark");
        this.prePTA.pureRun();
        sparkTimer.stop();
        System.out.println(sparkTimer);
        this.select();
        this.extraStats();
    }

    protected abstract Map<Object, Integer> calculatingNode2Length();

    protected void select() {
        Stopwatch preTimer = Stopwatch.newAndStart("pre-analysis");
        Map<Object, Integer> ret = this.calculatingNode2Length();
        ret.forEach((sparkNode, l) -> {
            if (l > 0) {
                this.csnodes.add(PTAUtils.getIR(sparkNode));
            }
            SootMethod method = null;
            if (sparkNode instanceof LocalVarNode) {
                method = ((LocalVarNode)sparkNode).getMethod();
            } else if (sparkNode instanceof AllocNode) {
                AllocNode allocNode = (AllocNode)sparkNode;
                method = allocNode.getMethod();
            }
            if (method != null) {
                if (l == 0) {
                    this.PCSM.add(method);
                } else {
                    this.CSM.add(method);
                }
            }
        });
        this.PCSM.retainAll(this.CSM);
        this.CSM.removeAll(this.PCSM);
        this.csmethods.addAll(this.CSM);
        this.csmethods.addAll(this.PCSM);
        System.out.println("#CSNODES:" + this.csnodes.size());
        System.out.println("#CSMETHODS:" + this.csmethods.size());
        preTimer.stop();
        System.out.println(preTimer);
    }

    protected void extraStats() {
        int[] RM = new int[1];
        int[] PCN = new int[1];
        int[] NPCN = new int[1];
        int[] totalN = new int[1];
        for (ContextMethod momc : this.prePTA.getReachableMethods()) {
            SootMethod method = momc.method();
            HashSet<Object> nodes = new HashSet<Object>();
            if (!PTAUtils.hasBody(method)) {
                return;
            }
            MethodPAG srcmpag = this.pag.getMethodPAG(method);
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                FieldRefNode fr;
                VarNode base;
                Node from = (Node)((QueueReader)reader).next();
                Node node = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    nodes.add(((VarNode)from).getVariable());
                } else if (from instanceof AllocNode) {
                    nodes.add(((AllocNode)from).getNewExpr());
                } else if (from instanceof FieldRefNode && (base = (fr = (FieldRefNode)from).getBase()) instanceof LocalVarNode) {
                    nodes.add(base.getVariable());
                }
                if (node instanceof LocalVarNode) {
                    nodes.add(((VarNode)node).getVariable());
                    continue;
                }
                if (!(node instanceof FieldRefNode) || !((base = (fr = (FieldRefNode)node).getBase()) instanceof LocalVarNode)) continue;
                nodes.add(base.getVariable());
            }
            for (Stmt stmt : srcmpag.getInvokeStmts()) {
                LValue dest;
                AbstractInvokeExpr ie = (AbstractInvokeExpr)stmt.asInvokableStmt().getInvokeExpr().get();
                int numArgs = ie.getArgCount();
                for (int i = 0; i < numArgs; ++i) {
                    Immediate arg = ie.getArg(i);
                    if (!(arg.getType() instanceof ReferenceType) || arg instanceof NullConstant) continue;
                    nodes.add(arg);
                }
                if (stmt instanceof JAssignStmt && (dest = ((JAssignStmt)stmt).getLeftOp()).getType() instanceof ReferenceType) {
                    nodes.add(dest);
                }
                if (!(ie instanceof AbstractInstanceInvokeExpr)) continue;
                AbstractInstanceInvokeExpr iie = (AbstractInstanceInvokeExpr)ie;
                Local base = iie.getBase();
                nodes.add(base);
            }
            for (Object object : nodes) {
                boolean index = false;
                if (this.csnodes.contains(object)) {
                    index = true;
                }
                if (index) {
                    PCN[0] = PCN[0] + 1;
                } else {
                    NPCN[0] = NPCN[0] + 1;
                }
                totalN[0] = totalN[0] + 1;
            }
            RM[0] = RM[0] + 1;
        }
        RM[0] = RM[0] - 1;
        System.out.println("#ReachableMethod:" + RM[0]);
        System.out.println("#FCSM:" + this.CSM.size());
        System.out.println("#PCSM:" + this.PCSM.size());
        System.out.println("#CIM:" + (RM[0] - this.PCSM.size() - this.CSM.size()));
        System.out.println("#CIN: " + NPCN[0]);
        System.out.println("#CSN: " + PCN[0]);
        System.out.println("totalN: " + totalN[0]);
    }
}

