/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import sootup.core.model.SootClass;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class BenchmarkStat
implements AbstractStat {
    private final PTA pta;
    private int classes = 0;
    private int appClasses = 0;
    private int phantomClasses = 0;
    private int libClasses = 0;
    private Set<SootClass> reachableClasses;
    private Set<SootClass> reachableAppClasses;
    int libReachableClasses = 0;

    public BenchmarkStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        View view = this.pta.getView();
        this.reachableClasses = this.pta.getNakedReachableMethods().stream().map(m -> {
            ClassType classType = m.getDeclaringClassType();
            return view.getClass(classType);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.reachableAppClasses = this.reachableClasses.stream().filter(SootClass::isApplicationClass).collect(Collectors.toSet());
        PTAScene scene = this.pta.getScene();
        this.classes = scene.getClasses().size();
        this.appClasses = scene.getApplicationClasses().size();
        this.phantomClasses = scene.getPhantomClasses().size();
        this.libClasses = this.classes - this.appClasses - this.phantomClasses;
        this.libReachableClasses = this.reachableClasses.size() - this.reachableAppClasses.size() - 1;
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Class:", String.valueOf(this.classes));
        exporter.collectMetric("#Appclass:", String.valueOf(this.appClasses));
        exporter.collectMetric("#Libclass:", String.valueOf(this.libClasses));
        exporter.collectMetric("#Phantomclass:", String.valueOf(this.phantomClasses));
        exporter.collectMetric("#Class(reachable):", String.valueOf(this.reachableClasses.size()));
        exporter.collectMetric("#Appclass(reachable):", String.valueOf(this.reachableAppClasses.size()));
        exporter.collectMetric("#Libclass(reachable):", String.valueOf(this.libReachableClasses));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpClassTypes(this.pta.getScene().getClasses());
        }
    }
}

