/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qilin.util.DataFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final Pattern qPat = Pattern.compile("'");

    public static byte[] toUtf8(String s) {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(s.length());
            DataOutputStream d = new DataOutputStream(bs);
            d.writeUTF(s);
            return bs.toByteArray();
        }
        catch (IOException e) {
            logger.debug("Some sort of IO exception in toUtf8 with " + s);
            return null;
        }
    }

    public static <K, V> boolean addToMap(Map<K, Set<V>> map, K key, V value) {
        return map.computeIfAbsent(key, k -> DataFactory.createSet()).add(value);
    }

    public static <K, V> boolean removeFromMap(Map<K, Set<V>> map, K key, V value) {
        if (!map.containsKey(key)) {
            return false;
        }
        return map.get(key).remove(value);
    }

    public static <T> void add(Map<String, T> map, T name, String ... aliases) {
        for (String alias : aliases) {
            map.put(alias, name);
        }
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static void writeToFile(String file, String content) {
        try {
            File mfile = new File(file);
            if (!mfile.exists()) {
                System.out.println(file);
                mfile.createNewFile();
            }
            try (FileWriter writer = new FileWriter(mfile);){
                writer.write(content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String stripQuotes(CharSequence s) {
        return qPat.matcher(s).replaceAll("");
    }
}

