/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.util.graph.DirectedGraph;

public class DirectedGraphImpl<N>
implements DirectedGraph<N> {
    protected Set<N> nodes = new HashSet<N>();
    protected Map<N, Set<N>> preds = new HashMap<N, Set<N>>();
    protected Map<N, Set<N>> succs = new HashMap<N, Set<N>>();

    public void addNode(N node) {
        this.nodes.add(node);
    }

    public void addEdge(N from, N to) {
        this.addNode(from);
        this.addNode(to);
        this.preds.computeIfAbsent(to, k -> new HashSet()).add(from);
        this.succs.computeIfAbsent(from, k -> new HashSet()).add(to);
    }

    @Override
    public Collection<N> allNodes() {
        return this.nodes;
    }

    @Override
    public Collection<N> predsOf(N n) {
        return this.preds.getOrDefault(n, Collections.emptySet());
    }

    @Override
    public Collection<N> succsOf(N n) {
        return this.succs.getOrDefault(n, Collections.emptySet());
    }
}

