/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import qilin.util.graph.DirectedGraph;

public class TopologicalSorter<N> {
    private DirectedGraph<N> graph;
    private List<N> sortedList;
    private Set<N> visited;

    public List<N> sort(DirectedGraph<N> graph) {
        return this.sort(graph, false);
    }

    public List<N> sort(DirectedGraph<N> graph, boolean reverse) {
        this.initialize(graph);
        graph.allNodes().stream().filter(n -> graph.succsOf(n).isEmpty()).forEach(this::visit);
        List<N> result = this.sortedList;
        if (reverse) {
            Collections.reverse(result);
        }
        this.clear();
        return result;
    }

    private void initialize(DirectedGraph<N> graph) {
        this.graph = graph;
        this.sortedList = new LinkedList<N>();
        this.visited = new HashSet<N>();
    }

    private void visit(N node) {
        if (!this.visited.contains(node)) {
            this.visited.add(node);
            this.graph.predsOf(node).forEach(this::visit);
            this.sortedList.add(node);
        }
    }

    private void clear() {
        this.graph = null;
        this.sortedList = null;
        this.visited = null;
    }
}

