/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ExtendedURLClassLoader;
import org.sosy_lab.common.annotations.Unmaintained;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;

public final class Classes {
    public static final com.google.common.base.Predicate<Class<?>> IS_GENERATED = pInput -> pInput.getSimpleName().startsWith("AutoValue_");

    private Classes() {
    }

    public static Path getCodeLocation(Class<?> cls) {
        try {
            return Path.of(cls.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public static <T> T createInstance(Class<? extends T> cls, Class<?> @Nullable [] argumentTypes, Object @Nullable [] argumentValues, Class<T> type) throws ClassInstantiationException, InvocationTargetException {
        Preconditions.checkNotNull(type);
        try {
            Constructor<T> ct = cls.getConstructor(argumentTypes);
            return ct.newInstance(argumentValues);
        }
        catch (IllegalAccessException | InstantiationException | SecurityException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), "Matching constructor not found!", e);
        }
    }

    @Deprecated
    public static <T> T createInstance(Class<T> type, Class<? extends T> cls, Class<?> @Nullable [] argumentTypes, Object[] argumentValues) throws InvalidConfigurationException {
        return Classes.createInstance(type, cls, argumentTypes, argumentValues, RuntimeException.class);
    }

    @Deprecated
    public static <T, X extends Exception> T createInstance(Class<T> type, Class<? extends T> cls, @Var Class<?> @Nullable [] argumentTypes, Object[] argumentValues, Class<X> exceptionType) throws X, InvalidConfigurationException {
        Constructor<T> ct;
        Preconditions.checkNotNull(exceptionType);
        if (argumentTypes == null) {
            argumentTypes = (Class[])Stream.of(argumentValues).map(Object::getClass).toArray(Class[]::new);
        } else {
            Preconditions.checkArgument((argumentTypes.length == argumentValues.length ? 1 : 0) != 0);
        }
        String className = cls.getSimpleName();
        String typeName = type.getSimpleName();
        try {
            ct = cls.getConstructor(argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", no matching constructor", e);
        }
        String exception = Classes.verifyDeclaredExceptions(ct, exceptionType, InvalidConfigurationException.class);
        if (exception != null) {
            throw new InvalidConfigurationException(String.format("Invalid %s %s, constructor declares unsupported checked exception %s.", typeName, className, exception));
        }
        try {
            return ct.newInstance(argumentValues);
        }
        catch (InstantiationException e) {
            throw new InvalidConfigurationException(String.format("Invalid %s %s, class cannot be instantiated (%s).", typeName, className, e.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", constructor is not accessible", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible((Throwable)t, exceptionType, InvalidConfigurationException.class);
            throw new UnexpectedCheckedException("instantiation of " + typeName + " " + className, t);
        }
    }

    public static Class<?> forName(String name, @Nullable String prefix) throws ClassNotFoundException {
        return Classes.forName(name, prefix, null);
    }

    private static Class<?> forName(String name, @Nullable String prefix, @Var @Nullable ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = Classes.class.getClassLoader();
        }
        if (Strings.isNullOrEmpty((String)prefix)) {
            return cl.loadClass(name);
        }
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return cl.loadClass(prefix + "." + name);
            }
            catch (ClassNotFoundException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }

    public static @Nullable String verifyDeclaredExceptions(Executable executable, Class<?> ... allowedExceptionTypes) {
        return Classes.verifyDeclaredExceptions(Arrays.asList(executable.getExceptionTypes()), Arrays.asList(allowedExceptionTypes));
    }

    public static @Nullable String verifyDeclaredExceptions(Invokable<?, ?> invokable, Class<?> ... allowedExceptionTypes) {
        return Classes.verifyDeclaredExceptions(FluentIterable.from((Iterable)invokable.getExceptionTypes()).transform(TypeToken::getRawType), Arrays.asList(allowedExceptionTypes));
    }

    @VisibleForTesting
    static @Nullable String verifyDeclaredExceptions(Iterable<Class<?>> declaredExceptionTypes, Iterable<Class<?>> pAllowedExceptionTypes) {
        FluentIterable allowedExceptionTypes = FluentIterable.from(pAllowedExceptionTypes).append((Object[])new Class[]{RuntimeException.class, Error.class});
        for (Class<?> declaredException : declaredExceptionTypes) {
            if (allowedExceptionTypes.anyMatch(allowedExceptionType -> allowedExceptionType.isAssignableFrom(declaredException))) continue;
            return declaredException.getSimpleName();
        }
        return null;
    }

    public static TypeToken<?> getSingleTypeArgument(TypeToken<?> type) {
        return TypeToken.of((Type)Classes.getSingleTypeArgument(type.getType()));
    }

    public static Type getSingleTypeArgument(Type type) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (String)"Cannot extract generic parameter from non-parameterized type %s", (Object)type);
        ParameterizedType pType = (ParameterizedType)type;
        Type[] parameterTypes = pType.getActualTypeArguments();
        Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Cannot extract generic parameter from parameterized type %s which has not exactly one parameter", (Object)type);
        return Classes.extractUpperBoundFromType(parameterTypes[0]);
    }

    public static Type extractUpperBoundFromType(@Var Type type) {
        Preconditions.checkNotNull((Object)type);
        if (type instanceof WildcardType) {
            WildcardType wcType = (WildcardType)type;
            if (wcType.getLowerBounds().length > 0) {
                throw new UnsupportedOperationException("Currently wildcard types with a lower bound like \"" + type + "\" are not supported ");
            }
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length != 1) {
                throw new UnsupportedOperationException("Currently only type bounds with one upper bound are supported, not \"" + type + "\"");
            }
            type = upperBounds[0];
        }
        return type;
    }

    public static void produceClassLoadingWarning(LogManager logger, Class<?> cls, @Nullable Class<?> type) {
        String typeName;
        Preconditions.checkNotNull((Object)logger);
        Package pkg = cls.getPackage();
        String string = typeName = type == null ? "class" : type.getSimpleName();
        if (cls.isAnnotationPresent(Deprecated.class) || pkg.isAnnotationPresent(Deprecated.class)) {
            logger.logf(Level.WARNING, "Using %s %s, which is marked as deprecated and should not be used.", typeName, cls.getSimpleName());
        } else if (cls.isAnnotationPresent(Unmaintained.class) || pkg.isAnnotationPresent(Unmaintained.class)) {
            logger.logf(Level.WARNING, "Using %s %s, which is unmaintained and may not work correctly.", typeName, cls.getSimpleName());
        }
    }

    public static ClassLoaderBuilder<?> makeExtendedURLClassLoader() {
        return ((ExtendedURLClassLoader.ExtendedURLClassLoaderConfiguration.AutoBuilder)ExtendedURLClassLoader.ExtendedURLClassLoaderConfiguration.builder().setDirectLoadClasses(c -> false)).setCustomLookupNativeLibraries(l -> false);
    }

    public static <I> I createFactory(Class<I> factoryType, Class<?> cls) throws UnsuitedClassException {
        return Classes.createFactory(TypeToken.of(factoryType), cls);
    }

    public static <I> I createFactory(final TypeToken<I> factoryType, Class<?> cls) throws UnsuitedClassException {
        Class factoryInterface = factoryType.getRawType();
        Preconditions.checkNotNull(cls);
        Preconditions.checkArgument((boolean)factoryInterface.isInterface());
        Preconditions.checkArgument((factoryInterface.getMethods().length == 1 ? 1 : 0) != 0, (String)"Factory interface %s does not declare exactly one method", factoryType);
        final Method interfaceMethod = factoryInterface.getMethods()[0];
        TypeToken returnType = factoryType.resolveType(interfaceMethod.getGenericReturnType());
        Class[] allowedExceptions = (Class[])Classes.resolve(factoryType, interfaceMethod.getGenericExceptionTypes()).map(TypeToken::getRawType).toArray(Class[]::new);
        Parameter[] formalParams = interfaceMethod.getParameters();
        ImmutableList formalParamTypes = (ImmutableList)Classes.resolve(factoryType, interfaceMethod.getGenericParameterTypes()).collect(ImmutableList.toImmutableList());
        for (Multiset.Entry entry : ImmutableMultiset.copyOf((Iterable)formalParamTypes).entrySet()) {
            Verify.verify((entry.getCount() == 1 ? 1 : 0) != 0, (String)"Method %s of factory interface %s declares parameter of type %s multiple times", (Object)interfaceMethod.getName(), factoryType, (Object)entry.getElement());
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            throw new UnsuitedClassException("class is not public", new Object[0]);
        }
        final Executable target = Classes.getInstantiationMethodForClass(cls);
        if (!returnType.isSupertypeOf(TypeToken.of((Type)target.getAnnotatedReturnType().getType()))) {
            throw new UnsuitedClassException("'%s' does not produce instances of %s", target, returnType);
        }
        String exception = Classes.verifyDeclaredExceptions(target, allowedExceptions);
        if (exception != null) {
            throw new UnsuitedClassException("'%s' declares illegal checked exception %s", target, exception);
        }
        Parameter[] targetParameters = target.getParameters();
        ImmutableList targetParamTypes = (ImmutableList)Arrays.stream(targetParameters).map(Parameter::getAnnotatedType).map(AnnotatedType::getType).map(TypeToken::of).collect(ImmutableList.toImmutableList());
        final int[] parameterMapping = new int[targetParamTypes.size()];
        final boolean[] parameterNullability = new boolean[targetParamTypes.size()];
        for (int i = 0; i < targetParamTypes.size(); ++i) {
            boolean sourceNullability;
            boolean targetNullability = Classes.isNullable(targetParameters[i]);
            int sourceIndex = formalParamTypes.indexOf(targetParamTypes.get(i));
            boolean bl = sourceNullability = sourceIndex == -1 || Classes.isNullable(formalParams[sourceIndex]);
            if (sourceNullability && !targetNullability) {
                throw new UnsuitedClassException("'%s' requires parameter of type %s which is not present in factory interface", target, targetParamTypes.get(i));
            }
            parameterNullability[i] = sourceNullability && targetNullability;
            parameterMapping[i] = sourceIndex;
        }
        final class FactoryInvocationHandler
        extends AbstractInvocationHandler {
            FactoryInvocationHandler() {
            }

            protected Object handleInvocation(Object pProxy, Method pMethod, Object[] pActualArgs) throws Throwable {
                Verify.verify((boolean)pMethod.equals(interfaceMethod));
                Object[] targetArgs = new Object[parameterMapping.length];
                for (int i = 0; i < parameterMapping.length; ++i) {
                    Object value;
                    Object object = value = parameterMapping[i] == -1 ? null : pActualArgs[parameterMapping[i]];
                    if (value == null && !parameterNullability[i]) {
                        throw new NullPointerException(String.format("Value null for parameter %d of type %s in %s", new Object[]{i, interfaceMethod.getGenericParameterTypes()[i], this}));
                    }
                    targetArgs[i] = value;
                }
                try {
                    if (target instanceof Method) {
                        return ((Method)target).invoke(null, targetArgs);
                    }
                    if (target instanceof Constructor) {
                        return ((Constructor)target).newInstance(targetArgs);
                    }
                    throw new AssertionError((Object)("Unknown Executable " + target));
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            public String toString() {
                return factoryType + " implementation for '" + target + "'";
            }
        }
        Object factory = Reflection.newProxy((Class)factoryInterface, (InvocationHandler)((Object)new FactoryInvocationHandler()));
        return (I)factory;
    }

    private static Stream<TypeToken<?>> resolve(TypeToken<?> context, Type[] types) {
        return Arrays.stream(types).map(type -> context.resolveType(type));
    }

    private static boolean isNullable(Parameter elem) {
        return Classes.isNullable((AnnotatedElement)elem) || Classes.isNullable(elem.getAnnotatedType());
    }

    private static boolean isNullable(AnnotatedElement elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            String name = annotation.annotationType().getSimpleName();
            if (!name.equals("Nullable") && !name.equals("NullableDecl")) continue;
            return true;
        }
        return false;
    }

    private static Executable getInstantiationMethodForClass(Class<?> cls) throws UnsuitedClassException {
        ImmutableList factoryMethods = (ImmutableList)Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.getName().equals("create")).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> !m.isSynthetic()).collect(ImmutableList.toImmutableList());
        switch (factoryMethods.size()) {
            case 0: {
                if (Modifier.isAbstract(cls.getModifiers())) {
                    throw new UnsuitedClassException("class is abstract", new Object[0]);
                }
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors.length != 1) {
                    throw new UnsuitedClassException("class does not have a static method \"create\" nor exactly one public constructor", new Object[0]);
                }
                return constructors[0];
            }
            case 1: {
                return (Executable)factoryMethods.get(0);
            }
        }
        throw new UnsuitedClassException("class has more than one static methods named \"create\"", new Object[0]);
    }

    public static final class UnsuitedClassException
    extends Exception {
        private static final long serialVersionUID = 5091662820905162461L;

        @FormatMethod
        UnsuitedClassException(String msg, Object ... args) {
            super(String.format(msg, args));
        }
    }

    public static abstract class ClassLoaderBuilder<B extends ClassLoaderBuilder<B>> {
        ClassLoaderBuilder() {
        }

        @CanIgnoreReturnValue
        public abstract B setParent(ClassLoader var1);

        @CanIgnoreReturnValue
        public abstract B setUrls(Iterable<URL> var1);

        @CanIgnoreReturnValue
        public abstract B setUrls(URL ... var1);

        @CanIgnoreReturnValue
        public B setParentAndUrls(URLClassLoader parent) {
            return ((ClassLoaderBuilder)this.setParent(parent)).setUrls(parent.getURLs());
        }

        @CanIgnoreReturnValue
        public abstract B setDirectLoadClasses(Predicate<String> var1);

        @CanIgnoreReturnValue
        public B setDirectLoadClasses(Pattern classes) {
            return this.setDirectLoadClasses(ClassLoaderBuilder.matching(classes));
        }

        @CanIgnoreReturnValue
        public abstract B setCustomLookupNativeLibraries(Predicate<String> var1);

        @CanIgnoreReturnValue
        public B setCustomLookupNativeLibraries(Pattern nativeLibraries) {
            return this.setCustomLookupNativeLibraries(ClassLoaderBuilder.matching(nativeLibraries));
        }

        @CanIgnoreReturnValue
        public B setCustomLookupNativeLibraries(String ... nativeLibraries) {
            return this.setCustomLookupNativeLibraries(arg_0 -> ((ImmutableSet)ImmutableSet.copyOf((Object[])nativeLibraries)).contains(arg_0));
        }

        private static Predicate<String> matching(Pattern pattern) {
            return s -> pattern.matcher((CharSequence)s).matches();
        }

        abstract ExtendedURLClassLoader.ExtendedURLClassLoaderConfiguration autoBuild();

        @CheckReturnValue
        public abstract URLClassLoader build();
    }

    public static final class UnexpectedCheckedException
    extends RuntimeException {
        private static final long serialVersionUID = -8706288432548996095L;

        public UnexpectedCheckedException(String message, Throwable source) {
            super("Unexpected checked exception " + source.getClass().getSimpleName() + (String)(Strings.isNullOrEmpty((String)message) ? "" : " during " + message) + (String)(Strings.isNullOrEmpty((String)source.getMessage()) ? "" : ": " + source.getMessage()), source);
            assert (source instanceof Exception && !(source instanceof RuntimeException));
        }
    }

    @Deprecated
    public static class ClassInstantiationException
    extends Exception {
        private static final long serialVersionUID = 7862065219560550275L;

        public ClassInstantiationException(String className, String msg, Throwable cause) {
            super("Cannot instantiate class " + className + ":" + msg, cause);
        }

        public ClassInstantiationException(String className, Throwable cause) {
            super("Cannot instantiate class " + className + ":" + cause.getMessage(), cause);
        }
    }
}

