/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Ascii;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;

public final class NativeLibraries {
    private static @Nullable Path nativePath = null;

    private NativeLibraries() {
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static Path getNativeLibraryPath() {
        if (nativePath == null) {
            String arch = Ascii.toLowerCase((String)Architecture.guessVmArchitecture().name());
            String os = Ascii.toLowerCase((String)OS.guessOperatingSystem().name());
            nativePath = Classes.getCodeLocation(NativeLibraries.class).getParent().getParent().getParent().resolve(Path.of("native", arch + "-" + os));
        }
        return nativePath;
    }

    public static void loadLibrary(String name) {
        Optional<Path> path = NativeLibraries.findPathForLibrary(name);
        if (path.isPresent()) {
            System.load(path.orElseThrow().toAbsolutePath().toString());
        } else {
            System.loadLibrary(name);
        }
    }

    @Deprecated
    public static Optional<Path> findPathForLibrary(String libraryName) {
        String osLibName = System.mapLibraryName(libraryName);
        Path p = NativeLibraries.getNativeLibraryPath().resolve(osLibName).toAbsolutePath();
        if (Files.exists(p, new LinkOption[0])) {
            return Optional.of(p);
        }
        p = Classes.getCodeLocation(NativeLibraries.class).resolveSibling(osLibName).toAbsolutePath();
        if (Files.exists(p, new LinkOption[0])) {
            return Optional.of(p);
        }
        return Optional.empty();
    }

    @Deprecated
    public static enum Architecture {
        X86,
        X86_64;

        private static @Nullable Architecture currentArch;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Architecture guessVmArchitecture() {
            if (currentArch != null) {
                return currentArch;
            }
            String prop = System.getProperty("os.arch.data.model");
            if (Strings.isNullOrEmpty((String)prop)) {
                prop = System.getProperty("sun.arch.data.model");
            }
            if (!Strings.isNullOrEmpty((String)prop)) {
                switch (prop) {
                    case "32": {
                        currentArch = X86;
                        return currentArch;
                    }
                    case "64": {
                        currentArch = X86_64;
                        return currentArch;
                    }
                    default: {
                        throw new UnsatisfiedLinkError("Unknown value for os.arch.data.model: '" + prop + "', please report this together with information about your system (OS, architecture, JVM).");
                    }
                }
            } else {
                prop = StandardSystemProperty.JAVA_VM_NAME.value();
                if (Strings.isNullOrEmpty((String)prop)) throw new UnsatisfiedLinkError("Could not detect system architecture");
                if ((prop = Ascii.toLowerCase((String)prop)).contains("32-bit") || prop.contains("32bit") || prop.contains("i386")) {
                    currentArch = X86;
                    return currentArch;
                } else {
                    if (!prop.contains("64-bit") && !prop.contains("64bit") && !prop.contains("x64") && !prop.contains("x86_64") && !prop.contains("amd64")) throw new UnsatisfiedLinkError("Unknown value for java.vm.name: '" + prop + "', please report this together with information about your system (OS, architecture, JVM).");
                    currentArch = X86_64;
                }
            }
            return currentArch;
        }

        static {
            currentArch = null;
        }
    }

    @Deprecated
    public static enum OS {
        LINUX,
        MACOSX,
        WINDOWS;

        private static @Nullable OS currentOS;

        public static OS guessOperatingSystem() {
            if (currentOS != null) {
                return currentOS;
            }
            String prop = StandardSystemProperty.OS_NAME.value();
            if (Strings.isNullOrEmpty((String)prop)) {
                throw new UnsatisfiedLinkError("No value for os.name, please report this together with information about your system (OS, architecture, JVM).");
            }
            if ((prop = Ascii.toLowerCase((String)prop.replace(" ", ""))).startsWith("linux")) {
                currentOS = LINUX;
            } else if (prop.startsWith("windows")) {
                currentOS = WINDOWS;
            } else if (prop.startsWith("macosx")) {
                currentOS = MACOSX;
            } else {
                throw new UnsatisfiedLinkError("Unknown value for os.name: '" + StandardSystemProperty.OS_NAME.value() + "', please report this together with information about your system (OS, architecture, JVM).");
            }
            return currentOS;
        }

        static {
            currentOS = null;
        }
    }
}

