/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.collect.Ordering;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.NonNull;

@SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
final class OptionalComparators {
    static final Ordering<OptionalInt> INT_EMPTY_FIRST = new OptionalIntComparator(true);
    static final Ordering<OptionalInt> INT_EMPTY_LAST = new OptionalIntComparator(false);
    static final Ordering<OptionalLong> LONG_EMPTY_FIRST = new OptionalLongComparator(true);
    static final Ordering<OptionalLong> LONG_EMPTY_LAST = new OptionalLongComparator(false);
    static final Ordering<OptionalDouble> DOUBLE_EMPTY_FIRST = new OptionalDoubleComparator(true);
    static final Ordering<OptionalDouble> DOUBLE_EMPTY_LAST = new OptionalDoubleComparator(false);

    private OptionalComparators() {
    }

    private static final class OptionalDoubleComparator
    extends Ordering<OptionalDouble>
    implements Serializable {
        private static final long serialVersionUID = -3210510142079410508L;
        private final boolean emptyFirst;

        private OptionalDoubleComparator(boolean pEmptyFirst) {
            this.emptyFirst = pEmptyFirst;
        }

        public int compare(@NonNull OptionalDouble left, @NonNull OptionalDouble right) {
            if (!left.isPresent()) {
                if (right.isPresent()) {
                    return this.emptyFirst ? -1 : 1;
                }
                return 0;
            }
            if (!right.isPresent()) {
                return this.emptyFirst ? 1 : -1;
            }
            return Double.compare(left.orElseThrow(), right.orElseThrow());
        }

        public String toString() {
            return "Optionals.comparingDoubleEmpty" + (this.emptyFirst ? "First" : "Last") + "()";
        }

        private Object readResolve() {
            return this.emptyFirst ? DOUBLE_EMPTY_FIRST : DOUBLE_EMPTY_LAST;
        }
    }

    private static final class OptionalLongComparator
    extends Ordering<OptionalLong>
    implements Serializable {
        private static final long serialVersionUID = -8237349997441501776L;
        private final boolean emptyFirst;

        private OptionalLongComparator(boolean pEmptyFirst) {
            this.emptyFirst = pEmptyFirst;
        }

        public int compare(@NonNull OptionalLong left, @NonNull OptionalLong right) {
            if (!left.isPresent()) {
                if (right.isPresent()) {
                    return this.emptyFirst ? -1 : 1;
                }
                return 0;
            }
            if (!right.isPresent()) {
                return this.emptyFirst ? 1 : -1;
            }
            return Long.compare(left.orElseThrow(), right.orElseThrow());
        }

        public String toString() {
            return "Optionals.comparingLongEmpty" + (this.emptyFirst ? "First" : "Last") + "()";
        }

        private Object readResolve() {
            return this.emptyFirst ? LONG_EMPTY_FIRST : LONG_EMPTY_LAST;
        }
    }

    private static final class OptionalIntComparator
    extends Ordering<OptionalInt>
    implements Serializable {
        private static final long serialVersionUID = 4448617946052179218L;
        private final boolean emptyFirst;

        private OptionalIntComparator(boolean pEmptyFirst) {
            this.emptyFirst = pEmptyFirst;
        }

        public int compare(@NonNull OptionalInt left, @NonNull OptionalInt right) {
            if (!left.isPresent()) {
                if (right.isPresent()) {
                    return this.emptyFirst ? -1 : 1;
                }
                return 0;
            }
            if (!right.isPresent()) {
                return this.emptyFirst ? 1 : -1;
            }
            return Integer.compare(left.orElseThrow(), right.orElseThrow());
        }

        public String toString() {
            return "Optionals.comparingIntEmpty" + (this.emptyFirst ? "First" : "Last") + "()";
        }

        private Object readResolve() {
            return this.emptyFirst ? INT_EMPTY_FIRST : INT_EMPTY_LAST;
        }
    }
}

