/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;

public final class ShutdownManager {
    private final ShutdownNotifier.ShutdownRequestListener ourListener = this::requestShutdown;
    private final ShutdownNotifier notifier = new ShutdownNotifier(this);
    private final @Nullable ShutdownNotifier parent;

    private ShutdownManager(@Nullable ShutdownNotifier pParent) {
        this.parent = pParent;
    }

    public static ShutdownManager create() {
        return new ShutdownManager(null);
    }

    public static ShutdownManager createWithParent(ShutdownNotifier parent) {
        ShutdownManager child = new ShutdownManager((ShutdownNotifier)Preconditions.checkNotNull((Object)parent));
        parent.registerAndCheckImmediately(child.ourListener);
        return child;
    }

    public ShutdownNotifier getNotifier() {
        return this.notifier;
    }

    public void requestShutdown(String pReason) {
        this.notifier.requestShutdown(pReason);
    }
}

