/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Streams;
import com.google.common.primitives.Chars;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Collections3 {
    private Collections3() {
    }

    public static boolean allElementsEqual(Iterable<?> iterable) {
        return Collections3.allElementsEqual(iterable.iterator());
    }

    public static boolean allElementsEqual(Object[] array) {
        return Collections3.allElementsEqual(Iterators.forArray((Object[])array));
    }

    public static boolean allElementsEqual(Stream<?> stream) {
        return Collections3.allElementsEqual(((Stream)stream.unordered()).iterator());
    }

    private static boolean allElementsEqual(Iterator<?> it) {
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Input was empty");
        Object o = it.next();
        while (it.hasNext()) {
            if (Objects.equals(o, it.next())) continue;
            return false;
        }
        return true;
    }

    public static <T1, T2> ImmutableList<T2> transformedImmutableListCopy(Collection<T1> input, Function<? super T1, T2> transformer) {
        return ImmutableList.copyOf((Collection)Collections2.transform(input, transformer));
    }

    public static <T1, T2> ImmutableList<T2> transformedImmutableListCopy(T1[] input, Function<? super T1, T2> transformer) {
        return ImmutableList.copyOf((Collection)Lists.transform(Arrays.asList(input), transformer));
    }

    public static <T1, T2> ImmutableSet<T2> transformedImmutableSetCopy(Collection<T1> input, Function<? super T1, T2> transformer) {
        return ImmutableSet.copyOf((Collection)Collections2.transform(input, transformer));
    }

    public static <K, V, R> Stream<R> zipMapEntries(Map<K, V> map, BiFunction<K, V, R> func) {
        Preconditions.checkNotNull(func);
        return map.entrySet().stream().map(entry -> func.apply(entry.getKey(), entry.getValue()));
    }

    public static <K, V, R> Stream<R> zipMapEntries(Iterable<Map.Entry<K, V>> entries, BiFunction<K, V, R> func) {
        Preconditions.checkNotNull(func);
        return Streams.stream(entries).map(entry -> func.apply(entry.getKey(), entry.getValue()));
    }

    public static <T> Stream<T> filterByClass(Stream<? super T> stream, Class<T> cls) {
        return stream.filter(cls::isInstance);
    }

    public static <T> Stream<T> filterByClass(Collection<? super T> collection, Class<T> cls) {
        return Collections3.filterByClass(collection.stream(), cls);
    }

    public static <T> Stream<T> filterByClass(Iterable<? super T> iterable, Class<T> cls) {
        return Collections3.filterByClass(Streams.stream(iterable), cls);
    }

    public static <T> ImmutableList<T> elementAndList(T elem, Collection<? extends T> coll) {
        return ImmutableList.builderWithExpectedSize((int)(coll.size() + 1)).add(elem).addAll(coll).build();
    }

    public static <T> ImmutableList<T> listAndElement(Collection<? extends T> coll, T elem) {
        return ImmutableList.builderWithExpectedSize((int)(coll.size() + 1)).addAll(coll).add(elem).build();
    }

    public static <T> ImmutableList<T> elementsAndList(T elem1, T elem2, Collection<? extends T> coll) {
        return ImmutableList.builderWithExpectedSize((int)(coll.size() + 2)).add(elem1).add(elem2).addAll(coll).build();
    }

    public static <T> ImmutableList<T> listAndSurroundingElements(T elem1, Collection<? extends T> coll, T elem2) {
        return ImmutableList.builderWithExpectedSize((int)(coll.size() + 2)).add(elem1).addAll(coll).add(elem2).build();
    }

    public static <T> ImmutableList<T> listAndElements(Collection<? extends T> coll, T elem1, T elem2) {
        return ImmutableList.builderWithExpectedSize((int)(coll.size() + 2)).addAll(coll).add(elem1).add(elem2).build();
    }

    public static <V> NavigableMap<String, V> subMapWithPrefix(NavigableMap<String, V> map, String prefix) {
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0);
        String end = Collections3.incrementStringByOne(prefix);
        return map.subMap(prefix, true, end, false);
    }

    public static <V> SortedMap<String, V> subMapWithPrefix(SortedMap<String, V> map, String prefix) {
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0);
        String end = Collections3.incrementStringByOne(prefix);
        return map.subMap(prefix, end);
    }

    public static NavigableSet<String> subSetWithPrefix(NavigableSet<String> set, String prefix) {
        Preconditions.checkNotNull(set);
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0);
        String end = Collections3.incrementStringByOne(prefix);
        return set.subSet(prefix, true, end, false);
    }

    public static SortedSet<String> subSetWithPrefix(SortedSet<String> set, String prefix) {
        Preconditions.checkNotNull(set);
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0);
        String end = Collections3.incrementStringByOne(prefix);
        return set.subSet(prefix, end);
    }

    private static String incrementStringByOne(String prefix) {
        StringBuilder end = new StringBuilder(prefix);
        int lastPos = end.length() - 1;
        end.setCharAt(lastPos, Chars.checkedCast((long)(end.charAt(lastPos) + '\u0001')));
        return end.toString();
    }

    private static boolean guaranteesNaturalOrder(@Nullable Comparator<?> comp) {
        return comp == null || comp.equals(Comparator.naturalOrder()) || comp.equals(Ordering.natural());
    }

    static boolean guaranteedSameOrder(@Nullable Comparator<?> comp1, @Nullable Comparator<?> comp2) {
        return Objects.equals(comp1, comp2) || Collections3.guaranteesNaturalOrder(comp1) && Collections3.guaranteesNaturalOrder(comp2);
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="handle null even if one of the collections does not")
    static boolean sortedSetEquals(SortedSet<?> coll1, @Nullable Object pColl2) {
        Preconditions.checkNotNull(coll1);
        if (coll1 == pColl2) {
            return true;
        }
        if (!(pColl2 instanceof Set)) {
            return false;
        }
        Set coll2 = (Set)pColl2;
        if (coll1.size() != coll2.size()) {
            return false;
        }
        if (pColl2 instanceof SortedSet && Collections3.guaranteedSameOrder(coll1.comparator(), ((SortedSet)coll2).comparator())) {
            Comparator comp = Objects.requireNonNullElse(coll1.comparator(), Comparator.naturalOrder());
            Iterator it1 = coll1.iterator();
            Iterator it2 = coll2.iterator();
            try {
                while (it1.hasNext()) {
                    Object element = it1.next();
                    Object otherElement = it2.next();
                    if (otherElement != null && comp.compare(element, otherElement) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        try {
            return coll1.containsAll(coll2);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="handle null even if comparator does not")
    static boolean sortedSetContainsAll(SortedSet<?> coll1, Collection<?> pColl2, @Nullable Equivalence<Object> pAdditionalEquality) {
        Preconditions.checkNotNull(coll1);
        if (pColl2.isEmpty()) {
            return true;
        }
        if (coll1.isEmpty()) {
            return false;
        }
        Set coll2 = pColl2 instanceof Multiset ? ((Multiset)pColl2).elementSet() : pColl2;
        if (coll2 instanceof SortedSet && Collections3.guaranteedSameOrder(coll1.comparator(), ((SortedSet)coll2).comparator())) {
            if (coll2.size() > coll1.size()) {
                return false;
            }
            Comparator comparator = Objects.requireNonNullElse(coll1.comparator(), Comparator.naturalOrder());
            Iterator it1 = coll1.iterator();
            Iterator it2 = coll2.iterator();
            Object val2 = it2.next();
            while (true) {
                int comp;
                Object val1 = it1.next();
                try {
                    comp = comparator.compare(val1, val2);
                }
                catch (ClassCastException | NullPointerException e) {
                    return false;
                }
                if (comp < 0) {
                    if (it1.hasNext()) continue;
                    return false;
                }
                if (comp > 0) {
                    return false;
                }
                if (pAdditionalEquality != null && !pAdditionalEquality.equivalent(val1, val2)) {
                    return false;
                }
                if (!it2.hasNext()) {
                    return true;
                }
                if (!it1.hasNext()) {
                    return false;
                }
                val2 = it2.next();
            }
        }
        for (Object val2 : coll2) {
            if (coll1.contains(val2)) continue;
            return false;
        }
        return true;
    }
}

