/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingNavigableMap;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;

public final class CopyOnWriteSortedMap<K, V>
extends ForwardingNavigableMap<K, V> {
    private final AtomicReference<PersistentSortedMap<K, V>> map;

    private CopyOnWriteSortedMap(PersistentSortedMap<K, V> pMap) {
        this.map = new AtomicReference<PersistentSortedMap>((PersistentSortedMap)Preconditions.checkNotNull(pMap));
    }

    public static <K extends Comparable<? super K>, V> CopyOnWriteSortedMap<K, V> copyOf(PersistentSortedMap<K, V> pMap) {
        return new CopyOnWriteSortedMap<K, V>(pMap);
    }

    public static <K extends Comparable<? super K>, V> CopyOnWriteSortedMap<K, V> copyOf(CopyOnWriteSortedMap<K, V> pMap) {
        return new CopyOnWriteSortedMap<K, V>(pMap.map.get());
    }

    protected NavigableMap<K, V> delegate() {
        return this.map.get();
    }

    public PersistentSortedMap<K, V> getSnapshot() {
        return this.map.get();
    }

    @CanIgnoreReturnValue
    public @Nullable V put(K pKey, V pValue) {
        PersistentSortedMap<K, V> oldMap = this.put0(pKey, pValue);
        return oldMap.get(pKey);
    }

    private PersistentSortedMap<K, V> put0(K pKey, V pValue) {
        PersistentMap newMap;
        PersistentSortedMap<K, V> oldMap;
        while (!this.map.compareAndSet((PersistentSortedMap<K, PersistentMap>)(oldMap = this.map.get()), (PersistentSortedMap<K, PersistentMap>)(newMap = oldMap.putAndCopy((Object)pKey, (Object)pValue)))) {
        }
        return oldMap;
    }

    @CanIgnoreReturnValue
    public @Nullable V remove(Object pKey) {
        PersistentMap newMap;
        PersistentSortedMap<K, V> oldMap;
        do {
            if ((oldMap = this.map.get()).containsKey(pKey)) continue;
            return null;
        } while (!this.map.compareAndSet((PersistentSortedMap<K, PersistentMap>)oldMap, (PersistentSortedMap<K, PersistentMap>)(newMap = oldMap.removeAndCopy(pKey))));
        return oldMap.get(pKey);
    }

    @CanIgnoreReturnValue
    public @Nullable Map.Entry<K, V> pollFirstEntry() {
        Map.Entry firstEntry;
        PersistentMap newMap;
        PersistentSortedMap<K, V> oldMap;
        do {
            if ((firstEntry = (oldMap = this.map.get()).firstEntry()) != null) continue;
            return null;
        } while (!this.map.compareAndSet((PersistentSortedMap<K, PersistentMap>)oldMap, (PersistentSortedMap<K, PersistentMap>)(newMap = oldMap.removeAndCopy(firstEntry.getKey()))));
        return firstEntry;
    }

    @CanIgnoreReturnValue
    public @Nullable Map.Entry<K, V> pollLastEntry() {
        Map.Entry lastEntry;
        PersistentMap newMap;
        PersistentSortedMap<K, V> oldMap;
        do {
            if ((lastEntry = (oldMap = this.map.get()).lastEntry()) != null) continue;
            return null;
        } while (!this.map.compareAndSet((PersistentSortedMap<K, PersistentMap>)oldMap, (PersistentSortedMap<K, PersistentMap>)(newMap = oldMap.removeAndCopy(lastEntry.getKey()))));
        return lastEntry;
    }

    public void putAll(Map<? extends K, ? extends V> pMap) {
        pMap.forEach((key, value) -> this.put(key, value));
    }

    public void clear() {
        this.map.set((PersistentSortedMap<K, PersistentMap>)this.map.get().empty());
    }

    public NavigableSet<Map.Entry<K, V>> entrySet() {
        return new ForwardingNavigableSet<Map.Entry<K, V>>(){

            protected NavigableSet<Map.Entry<K, V>> delegate() {
                return CopyOnWriteSortedMap.this.map.get().entrySet();
            }
        };
    }

    public NavigableSet<K> keySet() {
        return new ForwardingNavigableSet<K>(){

            protected NavigableSet<K> delegate() {
                return CopyOnWriteSortedMap.this.map.get().keySet();
            }
        };
    }

    public Collection<V> values() {
        return new ForwardingCollection<V>(){

            protected Collection<V> delegate() {
                return CopyOnWriteSortedMap.this.map.get().values();
            }
        };
    }

    public NavigableMap<K, V> headMap(final K pToKey) {
        this.map.get().headMap((Object)pToKey);
        return new ForwardingNavigableMap<K, V>(){

            protected NavigableMap<K, V> delegate() {
                return CopyOnWriteSortedMap.this.map.get().headMap(pToKey);
            }
        };
    }

    public NavigableMap<K, V> tailMap(final K pFromKey) {
        this.map.get().tailMap((Object)pFromKey);
        return new ForwardingNavigableMap<K, V>(){

            protected NavigableMap<K, V> delegate() {
                return CopyOnWriteSortedMap.this.map.get().tailMap(pFromKey);
            }
        };
    }

    public NavigableMap<K, V> subMap(final K pFromKey, final K pToKey) {
        this.map.get().subMap((Object)pFromKey, (Object)pToKey);
        return new ForwardingNavigableMap<K, V>(){

            protected NavigableMap<K, V> delegate() {
                return CopyOnWriteSortedMap.this.map.get().subMap(pFromKey, pToKey);
            }
        };
    }
}

