/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingNavigableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sosy_lab.common.collect.NaiveOrderStatisticSet;
import org.sosy_lab.common.collect.OrderStatisticMap;
import org.sosy_lab.common.collect.OrderStatisticSet;

final class NaiveOrderStatisticMap<K, V>
extends ForwardingNavigableMap<K, V>
implements OrderStatisticMap<K, V>,
Serializable {
    private static final long serialVersionUID = -3542217590830996599L;
    private final NavigableMap<K, V> delegate;

    private NaiveOrderStatisticMap(NavigableMap<K, V> pNavigableMap) {
        this.delegate = pNavigableMap;
    }

    static <K, V> NaiveOrderStatisticMap<K, V> createMap() {
        return new NaiveOrderStatisticMap(new TreeMap());
    }

    static <K, V> NaiveOrderStatisticMap<K, V> createMap(Comparator<? super K> pComparator) {
        return new NaiveOrderStatisticMap(new TreeMap((Comparator)Preconditions.checkNotNull(pComparator)));
    }

    static <K, V> NaiveOrderStatisticMap<K, V> createMapWithNaturalOrder(Map<? extends K, ? extends V> pMap) {
        return new NaiveOrderStatisticMap(new TreeMap((Map)Preconditions.checkNotNull(pMap)));
    }

    static <K, V> NaiveOrderStatisticMap<K, V> createMapWithSameOrder(SortedMap<K, ? extends V> pSortedMap) {
        return new NaiveOrderStatisticMap(new TreeMap((SortedMap)Preconditions.checkNotNull(pSortedMap)));
    }

    protected NavigableMap<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public K getKeyByRank(int pIndex) {
        return (K)Iterables.get(this.delegate.navigableKeySet(), (int)pIndex);
    }

    @Override
    public Map.Entry<K, V> getEntryByRank(int pIndex) {
        K key = this.getKeyByRank(pIndex);
        return Maps.immutableEntry(key, (Object)this.get(key));
    }

    @Override
    @CanIgnoreReturnValue
    public K removeByRank(int pIndex) {
        K key = this.getKeyByRank(pIndex);
        Object val = this.remove(key);
        assert (val != null) : "Key could be retrieved by rank, but no (or null) value associated";
        return key;
    }

    @Override
    public int rankOf(K pObj) {
        Preconditions.checkNotNull(pObj);
        return Iterables.indexOf(this.delegate.navigableKeySet(), o -> this.compareKey(o, pObj) == 0);
    }

    private int compareKey(K pFirst, K pSnd) {
        Comparator comparator = this.comparator();
        if (comparator != null) {
            return comparator.compare(pFirst, pSnd);
        }
        return ((Comparable)pFirst).compareTo(pSnd);
    }

    @Override
    public OrderStatisticSet<K> navigableKeySet() {
        return NaiveOrderStatisticSet.createView(super.navigableKeySet());
    }

    @Override
    public OrderStatisticSet<K> descendingKeySet() {
        return NaiveOrderStatisticSet.createView(super.descendingKeySet());
    }

    @Override
    public OrderStatisticMap<K, V> descendingMap() {
        return new NaiveOrderStatisticMap<K, V>(super.descendingMap());
    }

    @Override
    public OrderStatisticMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new NaiveOrderStatisticMap<K, V>(super.subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public OrderStatisticMap<K, V> headMap(K toKey, boolean inclusive) {
        return new NaiveOrderStatisticMap<K, V>(super.headMap(toKey, inclusive));
    }

    @Override
    public OrderStatisticMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new NaiveOrderStatisticMap<K, V>(super.tailMap(fromKey, inclusive));
    }

    @Override
    public OrderStatisticMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public OrderStatisticMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public OrderStatisticMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }
}

