/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.collect.OrderStatisticMap;

public abstract class OrderStatisticMapTestSuite {
    private static final ImmutableList<Map.Entry<String, String>> ELEMS = ImmutableList.of((Object)Maps.immutableEntry((Object)"aaa", (Object)"Vzza"), (Object)Maps.immutableEntry((Object)"hha", (Object)"Vppa"), (Object)Maps.immutableEntry((Object)"ppa", (Object)"Vhha"), (Object)Maps.immutableEntry((Object)"zza", (Object)"Vaaa"));
    private static final ImmutableList<Map.Entry<String, String>> ELEMS_ABOVE = ImmutableList.of((Object)Maps.immutableEntry((Object)"aab", (Object)"Vzzb"), (Object)Maps.immutableEntry((Object)"hhb", (Object)"Vppb"), (Object)Maps.immutableEntry((Object)"ppb", (Object)"Vhhb"), (Object)Maps.immutableEntry((Object)"zzb", (Object)"Vaab"));
    private static final ImmutableList<Map.Entry<String, String>> ELEMS_BELOW = ImmutableList.of((Object)Maps.immutableEntry((Object)"aa", (Object)"Vzz"), (Object)Maps.immutableEntry((Object)"hh", (Object)"Vpp"), (Object)Maps.immutableEntry((Object)"pp", (Object)"Vhh"), (Object)Maps.immutableEntry((Object)"zz", (Object)"Vaa"));
    private final OrderStatisticMapFactory factory;

    OrderStatisticMapTestSuite(OrderStatisticMapFactory pFactory) {
        this.factory = pFactory;
    }

    private OrderStatisticMap<String, String> createMap() {
        return this.factory.create((List<Map.Entry<String, String>>)ImmutableList.of());
    }

    private OrderStatisticMap<String, String> createMap(List<Map.Entry<String, String>> pEntries) {
        return this.factory.create(pEntries);
    }

    private static <K, V> void putEntry(Map<K, V> pMap, Map.Entry<K, V> pEntry) {
        pMap.put(pEntry.getKey(), pEntry.getValue());
    }

    private static <K, V> void removeEntry(Map<K, V> pMap, Map.Entry<K, V> pEntry) {
        Truth.assertThat(pMap.get(pEntry.getKey())).isEqualTo(pMap.remove(pEntry.getKey()));
    }

    @Test
    public void testEquals() {
        int i;
        int i2;
        EqualsTester mapEqualsTester = new EqualsTester();
        OrderStatisticMap<String, String> l1 = this.createMap();
        OrderStatisticMap<String, String> l2 = this.createMap();
        mapEqualsTester.addEqualityGroup(new Object[]{l1, l2});
        l1 = this.createMap();
        l2 = this.createMap();
        for (i2 = ELEMS.size() - 1; i2 >= 0; --i2) {
            l2.put((String)((Map.Entry)ELEMS.get(i2)).getKey(), (String)((Map.Entry)ELEMS.get(i2)).getValue());
        }
        for (i2 = 0; i2 < ELEMS.size(); ++i2) {
            l1.put((String)((Map.Entry)ELEMS.get(i2)).getKey(), (String)((Map.Entry)ELEMS.get(i2)).getValue());
        }
        OrderStatisticMap<String, String> l3 = this.createMap();
        for (i = ELEMS.size() - 1; i >= 0; --i) {
            l3.put((String)((Map.Entry)ELEMS.get(i)).getKey(), (String)((Map.Entry)ELEMS.get(i)).getValue());
        }
        for (i = 0; i < ELEMS.size(); ++i) {
            l3.put((String)((Map.Entry)ELEMS.get(i)).getKey(), (String)((Map.Entry)ELEMS.get(i)).getValue());
        }
        mapEqualsTester.addEqualityGroup(new Object[]{l1, l2, l3});
        mapEqualsTester.testEquals();
    }

    @Test
    public void testSerialize() {
        OrderStatisticMap<String, String> l = this.createMap();
        SerializableTester.reserializeAndAssert(l);
        for (int i = 100000; i >= 0; --i) {
            l.put(String.valueOf(i), String.valueOf(i));
        }
        SerializableTester.reserializeAndAssert(l);
    }

    @Test
    public void testSubmapView_mutation() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((String)((Map.Entry)ELEMS.get(1)).getKey(), true, (String)((Map.Entry)ELEMS.get(2)).getKey(), true);
        Map.Entry toAdd = (Map.Entry)ELEMS_BELOW.get(2);
        OrderStatisticMapTestSuite.putEntry(subMap, toAdd);
        Truth.assertThat(subMap).containsEntry(toAdd.getKey(), toAdd.getValue());
        Truth.assertThat(map).containsEntry(toAdd.getKey(), toAdd.getValue());
        OrderStatisticMapTestSuite.removeEntry(subMap, toAdd);
        Truth.assertThat(map).doesNotContainKey(toAdd.getKey());
        Truth.assertThat(subMap).doesNotContainKey(toAdd.getKey());
        OrderStatisticMapTestSuite.putEntry(map, toAdd);
        Truth.assertThat(subMap).containsEntry(toAdd.getKey(), toAdd.getValue());
        OrderStatisticMapTestSuite.removeEntry(map, toAdd);
        Truth.assertThat(subMap).doesNotContainEntry(toAdd.getKey(), toAdd.getValue());
    }

    @Test
    public void testSubmapView_outOfBounds_add() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((String)((Map.Entry)ELEMS_ABOVE.get(0)).getKey(), true, (String)((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), true);
        ImmutableMap toAdd = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{(Map.Entry)ELEMS.get(1), (Map.Entry)ELEMS_BELOW.get(2), (Map.Entry)ELEMS.get(2), (Map.Entry)ELEMS_ABOVE.get(3)});
        Map.Entry firstEntry = (Map.Entry)ELEMS.get(0);
        Map.Entry fourthEntry = (Map.Entry)ELEMS.get(3);
        Assert.assertThrows(IllegalArgumentException.class, () -> OrderStatisticMapTestSuite.putEntry(subMap, firstEntry));
        Assert.assertThrows(IllegalArgumentException.class, () -> OrderStatisticMapTestSuite.putEntry(subMap, fourthEntry));
        Assert.assertThrows(IllegalArgumentException.class, () -> subMap.putAll(toAdd));
    }

    @Test
    public void testSubmapView_outOfBounds_remove() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((String)((Map.Entry)ELEMS_ABOVE.get(1)).getKey(), true, (String)((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), true);
        OrderStatisticMapTestSuite.removeEntry(subMap, (Map.Entry)ELEMS.get(1));
        OrderStatisticMapTestSuite.removeEntry(subMap, (Map.Entry)ELEMS.get(3));
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        ImmutableMap toRemove = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{(Map.Entry)ELEMS_BELOW.get(2), (Map.Entry)ELEMS.get(2), (Map.Entry)ELEMS.get(1)});
        for (Map.Entry e : toRemove.entrySet()) {
            OrderStatisticMapTestSuite.removeEntry(subMap, e);
        }
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(map).doesNotContainEntry(((Map.Entry)ELEMS_BELOW.get(2)).getKey(), ((Map.Entry)ELEMS_BELOW.get(2)).getValue());
        Truth.assertThat(map).doesNotContainEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
    }

    @Test
    public void testSubmapView_outOfBounds_contains() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((String)((Map.Entry)ELEMS_ABOVE.get(1)).getKey(), true, (String)((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), true);
        Truth.assertThat(subMap).doesNotContainEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(subMap).doesNotContainEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        subMap = map.subMap((String)((Map.Entry)ELEMS_ABOVE.get(1)).getKey(), false, (String)((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), false);
        Truth.assertThat(subMap).doesNotContainEntry(((Map.Entry)ELEMS_ABOVE.get(1)).getKey(), ((Map.Entry)ELEMS_ABOVE.get(1)).getValue());
        Truth.assertThat(subMap).doesNotContainEntry(((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), ((Map.Entry)ELEMS_ABOVE.get(2)).getValue());
        subMap = map.subMap((String)((Map.Entry)ELEMS_ABOVE.get(0)).getKey(), true, (String)((Map.Entry)ELEMS_ABOVE.get(2)).getKey(), true);
        Truth.assertThat(subMap).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(subMap).containsEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
    }

    @Test
    public void testSubmapView_descending() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((Object)((String)((Map.Entry)ELEMS.get(1)).getKey()), true, (Object)((String)((Map.Entry)ELEMS.get(2)).getKey()), true).descendingMap();
        Truth.assertThat((Object)ELEMS.get(2)).isEqualTo(subMap.firstEntry());
        Truth.assertThat((Object)ELEMS.get(1)).isEqualTo(subMap.lastEntry());
        subMap = subMap.descendingMap();
        Truth.assertThat((Object)ELEMS.get(1)).isEqualTo(subMap.firstEntry());
        Truth.assertThat((Object)ELEMS.get(2)).isEqualTo(subMap.lastEntry());
    }

    @Test
    public void testKeyset_mutation() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableSet keySet = map.navigableKeySet();
        keySet.removeByRank(0);
        Truth.assertThat(map).doesNotContainKey(((Map.Entry)ELEMS.get(0)).getKey());
    }

    @Test
    public void testSubmapView_submapOfSubmap() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap subMap = map.subMap((Object)((String)((Map.Entry)ELEMS.get(1)).getKey()), true, (Object)((String)((Map.Entry)ELEMS.get(3)).getKey()), true);
        NavigableMap subSubMap = subMap.subMap((String)((Map.Entry)ELEMS.get(1)).getKey(), true, (String)((Map.Entry)ELEMS_BELOW.get(3)).getKey(), true);
        Truth.assertThat(subSubMap).doesNotContainEntry(((Map.Entry)ELEMS.get(0)).getKey(), ((Map.Entry)ELEMS.get(0)).getValue());
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
        Truth.assertThat(subSubMap).doesNotContainEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        subSubMap = subMap.subMap((String)((Map.Entry)ELEMS.get(1)).getKey(), true, (String)((Map.Entry)ELEMS.get(3)).getKey(), true);
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        subSubMap = subSubMap.subMap((String)((Map.Entry)ELEMS.get(1)).getKey(), false, (String)((Map.Entry)ELEMS.get(3)).getKey(), false);
        Truth.assertThat(subSubMap).doesNotContainEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(subSubMap).containsEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
        Truth.assertThat(subSubMap).doesNotContainEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
    }

    @Test
    public void testGetEntryByRank_valid() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        for (int i = 0; i < ELEMS.size(); ++i) {
            Truth.assertThat((Object)ELEMS.get(i)).isEqualTo(map.getEntryByRank(i));
        }
    }

    @Test
    public void testGetEntryByRank_outOfBounds() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        try {
            map.getEntryByRank(-1);
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            map.getEntryByRank(ELEMS.size());
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntryByRank_submapFirst() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String firstSubmapKey = (String)submapStart.getKey();
        String submapEndKey = (String)((Map.Entry)ELEMS.get(2)).getKey();
        NavigableMap subMap = map.subMap((Object)firstSubmapKey, true, (Object)submapEndKey, true);
        Map.Entry firstSubmapEntry = subMap.getEntryByRank(0);
        Truth.assertThat(firstSubmapEntry).isEqualTo((Object)submapStart);
    }

    @Test
    public void testGetEntryByRank_submapLast() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String firstSubmapKey = (String)submapStart.getKey();
        String submapEndKey = (String)((Map.Entry)ELEMS.get(2)).getKey();
        NavigableMap subMap = map.subMap((Object)firstSubmapKey, true, (Object)submapEndKey, true);
        Map.Entry lastSubmapEntry = subMap.getEntryByRank(subMap.size() - 1);
        Truth.assertThat(lastSubmapEntry).isEqualTo(ELEMS.get(2));
    }

    @Test
    public void testGetEntryByRank_descendingMapFirstElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        Map.Entry firstEntryDescending = descendingMap.getEntryByRank(0);
        Truth.assertThat(firstEntryDescending).isEqualTo(ELEMS.get(ELEMS.size() - 1));
    }

    @Test
    public void testGetEntryByRank_descendingMapSecondElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        Map.Entry sndEntryDescending = descendingMap.getEntryByRank(1);
        Truth.assertThat(sndEntryDescending).isEqualTo(ELEMS.get(ELEMS.size() - 2));
    }

    @Test
    public void testGetEntryByRank_descendingMapLastElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        Map.Entry lastEntryDescending = descendingMap.getEntryByRank(descendingMap.size() - 1);
        Truth.assertThat(lastEntryDescending).isEqualTo(ELEMS.get(0));
    }

    @Test
    public void testGetKeyByRank_valid() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        for (int i = 0; i < ELEMS.size(); ++i) {
            Truth.assertThat((String)((String)((Map.Entry)ELEMS.get(i)).getKey())).isEqualTo((Object)map.getKeyByRank(i));
        }
    }

    @Test
    public void testGetKeyByRank_outOfBounds() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        try {
            map.getKeyByRank(-1);
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            map.getKeyByRank(ELEMS.size());
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetKeyByRank_submapFirst() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String submapStartKey = (String)submapStart.getKey();
        String submapEnd = (String)((Map.Entry)ELEMS.get(2)).getKey();
        NavigableMap subMap = map.subMap((Object)submapStartKey, true, (Object)submapEnd, true);
        String firstSubmapKey = (String)subMap.getKeyByRank(0);
        Truth.assertThat((String)firstSubmapKey).isEqualTo((Object)submapStartKey);
    }

    @Test
    public void testGetKeyByRank_submapLast() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String submapStartKey = (String)submapStart.getKey();
        String submapEndKey = (String)((Map.Entry)ELEMS.get(2)).getKey();
        NavigableMap subMap = map.subMap((Object)submapStartKey, true, (Object)submapEndKey, true);
        String lastSubmapKey = (String)subMap.getKeyByRank(subMap.size() - 1);
        Truth.assertThat((String)lastSubmapKey).isEqualTo((Object)submapEndKey);
    }

    @Test
    public void testGetKeyByRank_descendingMapFirstElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        String expectedKey = (String)((Map.Entry)ELEMS.get(ELEMS.size() - 1)).getKey();
        String firstKeyDescending = (String)descendingMap.getKeyByRank(0);
        Truth.assertThat((String)firstKeyDescending).isEqualTo((Object)expectedKey);
    }

    @Test
    public void testGetKeyByRank_descendingMapSecondElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        String expectedKey = (String)((Map.Entry)ELEMS.get(ELEMS.size() - 2)).getKey();
        String sndKeyDescending = (String)descendingMap.getKeyByRank(1);
        Truth.assertThat((String)sndKeyDescending).isEqualTo((Object)expectedKey);
    }

    @Test
    public void testGetKeyByRank_descendingMapLastElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        String expectedKey = (String)((Map.Entry)ELEMS.get(0)).getKey();
        String lastKeyDescending = (String)descendingMap.getKeyByRank(descendingMap.size() - 1);
        Truth.assertThat((String)lastKeyDescending).isEqualTo((Object)expectedKey);
    }

    @Test
    public void testRemoveByRank_valid() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        map.removeByRank(2);
        Truth.assertThat(map).doesNotContainEntry(((Map.Entry)ELEMS.get(2)).getKey(), ((Map.Entry)ELEMS.get(2)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(0)).getKey(), ((Map.Entry)ELEMS.get(0)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        map.removeByRank(0);
        Truth.assertThat(map).doesNotContainEntry(((Map.Entry)ELEMS.get(0)).getKey(), ((Map.Entry)ELEMS.get(0)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        map.removeByRank(map.size() - 1);
        Truth.assertThat(map).doesNotContainEntry(((Map.Entry)ELEMS.get(3)).getKey(), ((Map.Entry)ELEMS.get(3)).getValue());
        Truth.assertThat(map).containsEntry(((Map.Entry)ELEMS.get(1)).getKey(), ((Map.Entry)ELEMS.get(1)).getValue());
        map.removeByRank(0);
        Truth.assertThat(map).isEmpty();
    }

    @Test
    public void testRemoveByRank_invalid() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        OrderStatisticMap<String, String> emptyMap = this.createMap();
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> map.removeByRank(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> map.removeByRank(map.size()));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> emptyMap.removeByRank(0));
    }

    @Test
    public void testRemoveByRank_submapFirst() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String submapStartKey = (String)submapStart.getKey();
        String submapEnd = (String)((Map.Entry)ELEMS.get(2)).getKey();
        NavigableMap subMap = map.subMap((Object)submapStartKey, true, (Object)submapEnd, true);
        String firstSubmapKey = (String)subMap.removeByRank(0);
        Truth.assertThat((String)firstSubmapKey).isEqualTo((Object)submapStartKey);
        Truth.assertThat((Map)subMap).doesNotContainEntry(submapStart.getKey(), submapStart.getValue());
        Truth.assertThat(map).doesNotContainEntry(submapStart.getKey(), submapStart.getValue());
    }

    @Test
    public void testRemoveByRank_submapLast() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        Map.Entry submapStart = (Map.Entry)ELEMS.get(1);
        String submapStartKey = (String)submapStart.getKey();
        Map.Entry submapEnd = (Map.Entry)ELEMS.get(2);
        String submapEndKey = (String)submapEnd.getKey();
        NavigableMap subMap = map.subMap((Object)submapStartKey, true, (Object)submapEndKey, true);
        String lastSubmapKey = (String)subMap.removeByRank(subMap.size() - 1);
        Truth.assertThat((String)lastSubmapKey).isEqualTo((Object)submapEndKey);
        Truth.assertThat((Map)subMap).doesNotContainEntry(submapEnd.getKey(), submapEnd.getValue());
        Truth.assertThat(map).doesNotContainEntry(submapEnd.getKey(), submapEnd.getValue());
    }

    @Test
    public void testRemoveByRank_descendingMapFirstElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        Map.Entry expectedRemove = (Map.Entry)ELEMS.get(ELEMS.size() - 1);
        String expectedRemoveKey = (String)expectedRemove.getKey();
        String firstKeyDescending = (String)descendingMap.removeByRank(0);
        Truth.assertThat((String)firstKeyDescending).isEqualTo((Object)expectedRemoveKey);
        Truth.assertThat((Map)descendingMap).doesNotContainEntry(expectedRemove.getKey(), expectedRemove.getValue());
        Truth.assertThat(map).doesNotContainEntry(expectedRemove.getKey(), expectedRemove.getValue());
    }

    @Test
    public void testRemoveByRank_descendingMapLastElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        NavigableMap descendingMap = map.descendingMap();
        Map.Entry expectedRemove = (Map.Entry)ELEMS.get(0);
        String expectedRemoveKey = (String)expectedRemove.getKey();
        String lastKeyDescending = (String)descendingMap.removeByRank(descendingMap.size() - 1);
        Truth.assertThat((String)lastKeyDescending).isEqualTo((Object)expectedRemoveKey);
        Truth.assertThat((Map)descendingMap).doesNotContainEntry(expectedRemove.getKey(), expectedRemove.getValue());
        Truth.assertThat(map).doesNotContainEntry(expectedRemove.getKey(), expectedRemove.getValue());
    }

    private static <K, V> void assertRankOf(K pKey, int pExpectedRank, OrderStatisticMap<K, V> pMap) {
        int actualRank = pMap.rankOf(pKey);
        Truth.assertThat((Integer)actualRank).isEqualTo((Object)pExpectedRank);
    }

    @Test
    public void testRankOf_firstElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        OrderStatisticMapTestSuite.assertRankOf((String)((Map.Entry)ELEMS.get(0)).getKey(), 0, map);
    }

    @Test
    public void testRankOf_secondElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        OrderStatisticMapTestSuite.assertRankOf((String)((Map.Entry)ELEMS.get(1)).getKey(), 1, map);
    }

    @Test
    public void testRankOf_lastElement() {
        OrderStatisticMap<String, String> map = this.createMap((List<Map.Entry<String, String>>)ELEMS);
        String key = (String)((Map.Entry)ELEMS.get(ELEMS.size() - 1)).getKey();
        int expectedRank = ELEMS.size() - 1;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, map);
    }

    @Test
    public void testRankOf_descendingMapFirstElement() {
        NavigableMap descendingMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).descendingMap();
        String key = (String)((Map.Entry)ELEMS.get(ELEMS.size() - 1)).getKey();
        int expectedRank = 0;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, descendingMap);
    }

    @Test
    public void testRankOf_descendingMapSecondElement() {
        NavigableMap descendingMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).descendingMap();
        String key = (String)((Map.Entry)ELEMS.get(ELEMS.size() - 2)).getKey();
        int expectedRank = 1;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, descendingMap);
    }

    @Test
    public void testRankOf_descendingMapLastElement() {
        NavigableMap descendingMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).descendingMap();
        String key = (String)((Map.Entry)ELEMS.get(0)).getKey();
        int expectedRank = ELEMS.size() - 1;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, descendingMap);
    }

    @Test
    public void testRankOf_subMapFirstElement() {
        String firstSubmapKey = (String)((Map.Entry)ELEMS.get(1)).getKey();
        String lastSubmapKey = (String)((Map.Entry)ELEMS.get(3)).getKey();
        NavigableMap subMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).subMap((Object)firstSubmapKey, true, (Object)lastSubmapKey, true);
        String key = firstSubmapKey;
        int expectedRank = 0;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, subMap);
    }

    @Test
    public void testRankOf_subMapLastElement() {
        String firstSubmapKey = (String)((Map.Entry)ELEMS.get(1)).getKey();
        String lastSubmapKey = (String)((Map.Entry)ELEMS.get(3)).getKey();
        NavigableMap subMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).subMap((Object)firstSubmapKey, true, (Object)lastSubmapKey, true);
        String key = lastSubmapKey;
        int expectedRank = subMap.size() - 1;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, subMap);
    }

    @Test
    public void testRankOf_subMapSecondElement() {
        String firstSubmapKey = (String)((Map.Entry)ELEMS.get(1)).getKey();
        String lastSubmapKey = (String)((Map.Entry)ELEMS.get(3)).getKey();
        NavigableMap subMap = this.createMap((List<Map.Entry<String, String>>)ELEMS).subMap((Object)firstSubmapKey, true, (Object)lastSubmapKey, true);
        String key = (String)((Map.Entry)ELEMS.get(2)).getKey();
        int expectedRank = 1;
        OrderStatisticMapTestSuite.assertRankOf(key, expectedRank, subMap);
    }

    protected static abstract class OrderStatisticMapFactory
    extends TestStringSortedMapGenerator {
        protected OrderStatisticMapFactory() {
        }

        protected abstract OrderStatisticMap<String, String> create(Map.Entry<String, String>[] var1);

        protected abstract OrderStatisticMap<String, String> create(List<Map.Entry<String, String>> var1);
    }
}

