/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionDetailAnnotation;
import org.sosy_lab.common.configuration.OptionPlainTextWriter;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.BaseTypeConverter;
import org.sosy_lab.common.configuration.converters.ClassTypeConverter;
import org.sosy_lab.common.configuration.converters.IntegerTypeConverter;
import org.sosy_lab.common.configuration.converters.TimeSpanTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;

public final class Configuration {
    static final String NO_DEPRECATED_PREFIX = "<NO_DEPRECATION>";
    private static boolean secureMode = false;
    private static final Splitter ARRAY_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter ANNOTATION_VALUE_SPLITTER = Splitter.on((String)"::").limit(2).trimResults();
    static final ImmutableMap<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> COLLECTIONS;
    static final Map<Class<?>, TypeConverter> DEFAULT_CONVERTERS;
    final ImmutableMap<String, String> properties;
    final ImmutableMap<String, Path> sources;
    final String prefix;
    final ImmutableMap<Class<?>, TypeConverter> converters;
    final Set<String> unusedProperties;
    final Set<String> deprecatedProperties;
    private @Nullable PrintStream printUsedOptions;
    private LogManager logger = LogManager.createNullLogManager();

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static void enableSecureModeGlobally() {
        secureMode = true;
    }

    public static Configuration defaultConfiguration() {
        return new Configuration((ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, Path>)ImmutableMap.of(), "", ImmutableMap.copyOf(DEFAULT_CONVERTERS), new HashSet<String>(0), new HashSet<String>(0), null, null);
    }

    public static Configuration copyWithNewPrefix(Configuration oldConfig, String newPrefix) {
        return new Configuration(oldConfig.properties, oldConfig.sources, newPrefix, oldConfig.converters, oldConfig.unusedProperties, oldConfig.deprecatedProperties, oldConfig.printUsedOptions, oldConfig.logger);
    }

    private static <T extends Iterable<?>> void putSafely(ImmutableMap.Builder<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> builder, Class<T> iface, Class<? extends T> impl) {
        assert (!impl.isInterface());
        builder.put(iface, impl);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static Map<Class<?>, TypeConverter> getDefaultConverters() {
        return DEFAULT_CONVERTERS;
    }

    static Map<Class<?>, TypeConverter> createConverterMap() {
        return new ForwardingMap<Class<?>, TypeConverter>(){
            private final Map<Class<?>, TypeConverter> delegate = new HashMap();

            protected Map<Class<?>, TypeConverter> delegate() {
                return this.delegate;
            }

            private void check(Class<?> cls, TypeConverter pValue) {
                Preconditions.checkNotNull(cls);
                Preconditions.checkNotNull((Object)pValue);
                Preconditions.checkArgument((!cls.isAnnotation() || cls.isAnnotationPresent(OptionDetailAnnotation.class) ? 1 : 0) != 0, (Object)"Can register type converters only for annotations which are option detail annotations");
            }

            public @Nullable TypeConverter put(Class<?> cls, TypeConverter pValue) {
                this.check(cls, pValue);
                return (TypeConverter)super.put(cls, (Object)pValue);
            }

            public void putAll(Map<? extends Class<?>, ? extends TypeConverter> pMap) {
                pMap.forEach(this::check);
                super.putAll(pMap);
            }

            public Set<Map.Entry<Class<?>, TypeConverter>> entrySet() {
                return Collections.unmodifiableSet(super.entrySet());
            }
        };
    }

    PrintStream getUsedOptionsPrintStream() {
        return this.printUsedOptions;
    }

    LogManager getLogger() {
        return this.logger;
    }

    Configuration(ImmutableMap<String, String> pProperties, ImmutableMap<String, Path> pSources, String pPrefix, ImmutableMap<Class<?>, TypeConverter> pConverters, Set<String> pUnusedProperties, Set<String> pDeprecatedProperties, @Nullable PrintStream pPrintUsedOptions, @Nullable LogManager pLogger) {
        Preconditions.checkNotNull(pProperties);
        Preconditions.checkNotNull(pSources);
        Preconditions.checkNotNull((Object)pPrefix);
        assert (pProperties.keySet().containsAll((Collection)pSources.keySet()));
        this.properties = pProperties;
        this.sources = pSources;
        this.prefix = pPrefix.isEmpty() ? "" : pPrefix + ".";
        this.converters = (ImmutableMap)Preconditions.checkNotNull(pConverters);
        this.unusedProperties = (Set)Preconditions.checkNotNull(pUnusedProperties);
        this.deprecatedProperties = (Set)Preconditions.checkNotNull(pDeprecatedProperties);
        this.printUsedOptions = pPrintUsedOptions;
        this.logger = Objects.requireNonNullElse(pLogger, LogManager.createNullLogManager());
    }

    public void enableLogging(LogManager pLogger) {
        Preconditions.checkState((boolean)this.logger.equals(LogManager.createNullLogManager()), (Object)"Logging already enabled.");
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
    }

    public void dumpUsedOptionsTo(PrintStream out) {
        Preconditions.checkNotNull((Object)out);
        Preconditions.checkState((this.printUsedOptions == null ? 1 : 0) != 0);
        this.printUsedOptions = out;
    }

    @Deprecated
    public @Nullable String getProperty(String key) {
        Preconditions.checkNotNull((Object)key);
        String result = (String)this.properties.get((Object)(this.prefix + key));
        this.unusedProperties.remove(this.prefix + key);
        if (result == null && !this.prefix.isEmpty()) {
            result = (String)this.properties.get((Object)key);
            this.unusedProperties.remove(key);
        }
        return result;
    }

    @Deprecated
    public boolean hasProperty(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.properties.containsKey((Object)(this.prefix + key)) || this.properties.containsKey((Object)key);
    }

    public Set<String> getUnusedProperties() {
        return Collections.unmodifiableSet(this.unusedProperties);
    }

    public Set<String> getDeprecatedProperties() {
        return Collections.unmodifiableSet(this.deprecatedProperties);
    }

    public String asPropertiesString() {
        return Collections3.zipMapEntries(this.properties, (key, value) -> key + " = " + value + "\n").sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining());
    }

    public void inject(Object obj) throws InvalidConfigurationException {
        Class<?> cls = obj.getClass();
        assert (cls.getSuperclass() == Object.class || Configuration.checkCallerClass(cls, StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass())) : "Configuration options of a " + cls.getSimpleName() + " instance injected by calls from a superclass. This is most likely a bug and the caller of this method should instead call 'inject(this, <CLASS>.cls)'";
        this.inject(obj, obj.getClass());
    }

    private static boolean checkCallerClass(Class<?> cls, Class<?> callerClass) {
        if (cls == callerClass) {
            return true;
        }
        return !callerClass.isAssignableFrom(cls);
    }

    public void inject(Object obj, Class<?> cls) throws InvalidConfigurationException {
        this.inject(obj, cls, obj);
    }

    public <T> void injectWithDefaults(T obj, Class<T> cls, T defaultsObject) throws InvalidConfigurationException {
        this.inject(obj, cls, defaultsObject);
    }

    private void inject(Object obj, Class<?> cls, Object defaultsObject) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkNotNull(cls);
        Preconditions.checkNotNull((Object)defaultsObject);
        Preconditions.checkArgument((boolean)cls.isAssignableFrom(obj.getClass()));
        Options options = cls.getAnnotation(Options.class);
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (String)"Class %s must have @Options annotation. If you used inject(Object), try inject(Object, Class) instead.", (Object)cls.getName());
        AccessibleObject[] fields = cls.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        AccessibleObject[] methods = cls.getDeclaredMethods();
        AccessibleObject.setAccessible(methods, true);
        try {
            for (AccessibleObject field : fields) {
                if (!field.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForField(obj, (Field)field, options, defaultsObject);
            }
            for (AccessibleObject method : methods) {
                if (!method.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForMethod(obj, (Method)method, options);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void recursiveInject(Object obj) throws InvalidConfigurationException {
        Class<?> cls = obj.getClass();
        Preconditions.checkArgument((boolean)cls.isAnnotationPresent(Options.class), (String)"Class %s must have @Options annotation.", (Object)cls.getName());
        do {
            if (!cls.isAnnotationPresent(Options.class)) continue;
            this.inject(obj, cls);
        } while ((cls = cls.getSuperclass()) != null);
    }

    private <T> void setOptionValueForField(Object obj, Field field, Options options, Object defaultsObject) throws InvalidConfigurationException, IllegalAccessException {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new UnsupportedOperationException("@Option is not allowed on static members");
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new UnsupportedOperationException("@Option is not allowed on final fields because Java doesn't guarantee visibility of new value");
        }
        Object defaultValue = null;
        try {
            defaultValue = field.get(defaultsObject);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Type checks above were not successful apparently.", e);
        }
        Object typedDefaultValue = defaultValue;
        TypeToken type = TypeToken.of((Type)field.getGenericType());
        Option option = field.getAnnotation(Option.class);
        String name = Configuration.getOptionName(options, field, option);
        Object value = this.getValue(options, field, typedDefaultValue, type, option, field, obj != defaultsObject);
        if (value == defaultValue && obj == defaultsObject) {
            this.logger.log(Level.CONFIG, "Option:", name, "Class:", field.getDeclaringClass().getName(), "field:", field.getName(), "value: <DEFAULT>");
            return;
        }
        this.logger.log(Level.CONFIG, "Option:", name, "Class:", field.getDeclaringClass().getName(), "field:", field.getName(), "value:", value);
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Type checks above were not successful apparently.", e);
        }
    }

    private void setOptionValueForMethod(Object obj, Method method, Options options) throws InvalidConfigurationException, IllegalAccessException {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new UnsupportedOperationException("@Option is not allowed on static members");
        }
        String exception = Classes.verifyDeclaredExceptions(method, InvalidConfigurationException.class);
        if (exception != null) {
            throw new UnsupportedOperationException("Method with @Option may not throw " + exception);
        }
        Type[] parameters = method.getGenericParameterTypes();
        if (parameters.length != 1) {
            throw new UnsupportedOperationException("Method with @Option must have exactly one parameter!");
        }
        TypeToken type = TypeToken.of((Type)parameters[0]);
        Option option = method.getAnnotation(Option.class);
        String name = Configuration.getOptionName(options, method, option);
        Object value = this.getValue(options, method, null, type, option, method, false);
        this.logger.logf(Level.CONFIG, "Option: %s Class: %s method: %s value: %s", name, method.getDeclaringClass().getName(), method.getName(), value);
        try {
            method.invoke(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Type checks above were not successful apparently.", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s\"%s", name, value, t.getMessage() != null ? " (" + t.getMessage() + ")" : ""), t);
            }
            Throwables.propagateIfPossible((Throwable)t, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("configuration injection in method " + method, t);
        }
    }

    static String getOptionName(Options options, Member member, Option option) {
        return Configuration.getOptionName(options, member, option, false);
    }

    private static String getOptionName(Options options, Member member, Option option, boolean isDeprecated) {
        Object optsPrefix;
        String name = "";
        if (isDeprecated) {
            name = option.deprecatedName();
            if (name.isEmpty()) {
                name = option.name();
            }
        } else {
            name = option.name();
        }
        if (name.isEmpty()) {
            name = member.getName();
        }
        if (isDeprecated) {
            optsPrefix = options.deprecatedPrefix();
            if (((String)optsPrefix).isEmpty()) {
                optsPrefix = options.prefix();
            }
        } else {
            optsPrefix = options.prefix();
        }
        if (!((String)optsPrefix).isEmpty()) {
            optsPrefix = (String)optsPrefix + ".";
        }
        return (String)optsPrefix + name;
    }

    private <T> @Nullable Object getValue(Options options, Member method, @Nullable T defaultValue, TypeToken<T> type, Option option, AnnotatedElement member, boolean defaultIsFromOtherInstance) throws InvalidConfigurationException {
        Object value;
        String optionDeprecatedName;
        String deprecatedValueStr;
        boolean isEnum = type.getRawType().isEnum();
        String optionName = Configuration.getOptionName(options, method, option);
        String valueStr = this.getValueString(optionName, option, isEnum);
        Annotation secondaryOption = Configuration.getSecondaryAnnotation(member);
        if (!options.deprecatedPrefix().equals(NO_DEPRECATED_PREFIX) && (deprecatedValueStr = this.getValueString(optionDeprecatedName = Configuration.getOptionName(options, method, option, true), option, isEnum)) != null && !deprecatedValueStr.equals(valueStr)) {
            if (valueStr == null) {
                valueStr = deprecatedValueStr;
                this.logger.logf(Level.WARNING, "Using deprecated name for option '%s'%s, please update your config to use the option name '%s' instead.", optionDeprecatedName, this.getOptionSourceForLogging(optionDeprecatedName), optionName);
            } else {
                this.logger.logf(Level.WARNING, "Option '%s'%s is set to a different value than its deprecated previous name '%s'%s, using the value '%s' of the former and ignoring the latter.", optionName, this.getOptionSourceForLogging(optionName), optionDeprecatedName, this.getOptionSourceForLogging(optionDeprecatedName), valueStr);
            }
        }
        if (valueStr != null) {
            if (secureMode && !option.secure()) {
                throw new InvalidConfigurationException("Configuration option " + optionName + " was specified, but is not allowed in secure mode.");
            }
            value = this.convertValue(optionName, valueStr, type, secondaryOption);
            if (member.isAnnotationPresent(Deprecated.class)) {
                this.deprecatedProperties.add(optionName);
            }
        } else {
            if (option.required()) {
                throw new InvalidConfigurationException("Required configuration option " + optionName + " is missing.");
            }
            value = this.convertDefaultValue(optionName, defaultValue, type, secondaryOption, defaultIsFromOtherInstance);
        }
        if (this.printUsedOptions != null) {
            this.printOptionInfos(member, optionName, valueStr, defaultValue);
        }
        return value;
    }

    private String getOptionSourceForLogging(String optionDeprecatedName) {
        String source;
        if (this.sources.containsKey((Object)optionDeprecatedName) && !(source = ((Path)this.sources.get((Object)optionDeprecatedName)).toString()).isEmpty()) {
            return " in file " + source;
        }
        return "";
    }

    private @Nullable String getValueString(String name, Option option, boolean alwaysUppercase) throws InvalidConfigurationException {
        String[] allowedValues;
        String valueStr = Configuration.trimToNull(this.getProperty(name));
        if (valueStr == null) {
            return null;
        }
        if (alwaysUppercase || option.toUppercase()) {
            valueStr = valueStr.toUpperCase(Locale.getDefault());
        }
        if ((allowedValues = option.values()).length > 0 && !Arrays.asList(allowedValues).contains(valueStr)) {
            throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s\" (not listed as allowed value)", name, valueStr));
        }
        String regexp = option.regexp();
        if (!regexp.isEmpty() && !valueStr.matches(regexp)) {
            throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s\" (does not match RegExp \"%s\").", name, valueStr, regexp));
        }
        return valueStr;
    }

    private static @Nullable Annotation getSecondaryAnnotation(AnnotatedElement element) {
        Annotation result = null;
        for (Annotation a : element.getDeclaredAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(OptionDetailAnnotation.class)) continue;
            if (result != null) {
                throw new UnsupportedOperationException("Both " + result + " and " + a + " are present at " + element);
            }
            result = a;
        }
        return result;
    }

    private static void checkApplicability(@Nullable Annotation annotation, @Var TypeToken<?> optionType) {
        if (annotation == null) {
            return;
        }
        List<Class<?>> applicableTypes = Arrays.asList(annotation.annotationType().getAnnotation(OptionDetailAnnotation.class).applicableTo());
        if (optionType.getRawType() == AnnotatedValue.class) {
            optionType = Classes.getSingleTypeArgument(optionType);
        }
        if (!applicableTypes.isEmpty() && !applicableTypes.contains(optionType.getRawType())) {
            throw new UnsupportedOperationException(String.format("Annotation %s is not applicable for options of type %s.", annotation, optionType));
        }
    }

    private void printOptionInfos(AnnotatedElement element, String name, @Nullable String valueStr, @Nullable Object defaultValue) {
        StringBuilder optionInfo = new StringBuilder();
        optionInfo.append(OptionPlainTextWriter.getOptionDescription(element)).append(name).append('\n');
        if (defaultValue != null) {
            String defaultStr = defaultValue instanceof Object[] ? Arrays.deepToString((Object[])defaultValue) : defaultValue.toString();
            optionInfo.append("    default value:  ").append(defaultStr).append('\n');
        }
        if (valueStr != null) {
            optionInfo.append("--> used value:     ").append(valueStr).append('\n');
        }
        this.printUsedOptions.println(optionInfo.toString());
    }

    private <T> @Nullable Object convertValue(String optionName, String valueStr, TypeToken<?> pType, @Nullable Annotation secondaryOption) throws InvalidConfigurationException {
        Class collectionClass = (Class)COLLECTIONS.get((Object)pType.getRawType());
        if (collectionClass == null && !pType.isArray()) {
            TypeToken type = pType.wrap();
            Configuration.checkApplicability(secondaryOption, type);
            return this.convertSingleValue(optionName, valueStr, type, secondaryOption);
        }
        TypeToken componentType = pType.isArray() ? (TypeToken)Preconditions.checkNotNull((Object)pType.getComponentType()) : Classes.getSingleTypeArgument(pType);
        componentType = componentType.wrap();
        Configuration.checkApplicability(secondaryOption, componentType);
        List<?> values = this.convertMultipleValues(optionName, valueStr, componentType, secondaryOption);
        if (pType.isArray()) {
            Class arrayComponentType = componentType.getRawType();
            Object[] result = ObjectArrays.newArray((Class)arrayComponentType, (int)values.size());
            return values.toArray(result);
        }
        assert (collectionClass != null);
        if (collectionClass == EnumSet.class) {
            assert (componentType.getRawType().isEnum());
            return Configuration.createEnumSetUnchecked(componentType.getRawType(), values);
        }
        if (componentType.getRawType().isEnum() && (collectionClass == Set.class || collectionClass == ImmutableSet.class)) {
            return BaseTypeConverter.invokeStaticMethod(Sets.class, "immutableEnumSet", Iterable.class, values, optionName);
        }
        return BaseTypeConverter.invokeStaticMethod(collectionClass, "copyOf", Iterable.class, values, optionName);
    }

    private @Nullable Object convertSingleValue(String optionName, @Var String valueStr, @Var TypeToken<?> type, @Nullable Annotation secondaryOption) throws InvalidConfigurationException {
        boolean isAnnotated = type.getRawType() == AnnotatedValue.class;
        String annotation = null;
        if (isAnnotated) {
            type = Classes.getSingleTypeArgument(type);
            Iterator parts = ANNOTATION_VALUE_SPLITTER.split((CharSequence)valueStr).iterator();
            valueStr = (String)parts.next();
            annotation = (String)Iterators.getNext(parts, null);
        }
        @Nullable Path source = !this.prefix.isEmpty() && this.properties.get((Object)(this.prefix + optionName)) != null ? (Path)this.sources.get((Object)(this.prefix + optionName)) : (Path)this.sources.get((Object)optionName);
        TypeConverter converter = this.getConverter(type, secondaryOption);
        AnnotatedValue<Object> result = converter.convert(optionName, valueStr, type, secondaryOption, source, Objects.requireNonNullElse(this.logger, LogManager.createNullLogManager()));
        if (result != null && isAnnotated) {
            result = AnnotatedValue.create(result, Optional.ofNullable(annotation));
        }
        return result;
    }

    private List<?> convertMultipleValues(String optionName, String valueStr, TypeToken<?> type, @Nullable Annotation secondaryOption) throws InvalidConfigurationException {
        Iterable values = ARRAY_SPLITTER.split((CharSequence)valueStr);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : values) {
            result.add(this.convertSingleValue(optionName, item, type, secondaryOption));
        }
        return result;
    }

    private <T> @Nullable Object convertDefaultValue(String optionName, @Nullable T defaultValue, TypeToken<T> type, @Nullable Annotation secondaryOption, boolean fromOtherInstance) throws InvalidConfigurationException {
        Object innerType = type.isArray() ? (TypeToken<T>)Preconditions.checkNotNull((Object)type.getComponentType()) : (COLLECTIONS.containsKey((Object)type.getRawType()) ? Classes.getSingleTypeArgument(type) : type);
        innerType = innerType.wrap();
        Configuration.checkApplicability(secondaryOption, innerType);
        if (type.equals(innerType)) {
            TypeConverter converter = this.getConverter(type, secondaryOption);
            if (fromOtherInstance) {
                return converter.convertDefaultValueFromOtherInstance(optionName, defaultValue, type, secondaryOption);
            }
            return converter.convertDefaultValue(optionName, defaultValue, type, secondaryOption);
        }
        return defaultValue;
    }

    private TypeConverter getConverter(TypeToken<?> type, @Nullable Annotation secondaryOption) {
        TypeConverter converter = null;
        if (secondaryOption != null) {
            converter = (TypeConverter)this.converters.get(secondaryOption.annotationType());
        }
        if (converter == null) {
            converter = (TypeConverter)this.converters.get((Object)type.getRawType());
        }
        if (converter == null) {
            converter = BaseTypeConverter.INSTANCE;
        }
        return converter;
    }

    private static @Nullable String trimToNull(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return Strings.emptyToNull((String)s.trim());
    }

    private static <T extends Enum<T>> EnumSet<?> createEnumSetUnchecked(Class<?> enumType, Collection<?> values) {
        EnumSet<?> result = EnumSet.noneOf(enumType);
        result.addAll(values);
        return result;
    }

    public String toString() {
        return "Configuration" + (String)(!this.prefix.isEmpty() ? " with prefix " + this.prefix : "") + ": [" + Joiner.on((String)", ").withKeyValueSeparator("=").join(this.properties) + "]";
    }

    public static Configuration fromCmdLineArguments(String[] args) throws InvalidConfigurationException {
        ConfigurationBuilder builder = Configuration.builder();
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                throw new InvalidConfigurationException("Invalid command-line argument '" + arg + "', --option=value syntax expected.");
            }
            List tokens = Splitter.on((String)"=").omitEmptyStrings().trimResults().splitToList((CharSequence)arg);
            if (tokens.size() != 2) {
                throw new InvalidConfigurationException("Invalid command-line argument '" + arg + "', --option=value syntax expected.");
            }
            builder.setOption(((String)tokens.get(0)).substring(2), (String)tokens.get(1));
        }
        return builder.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Configuration.putSafely(builder, EnumSet.class, EnumSet.class);
        Configuration.putSafely(builder, Iterable.class, ImmutableList.class);
        Configuration.putSafely(builder, Collection.class, ImmutableList.class);
        Configuration.putSafely(builder, List.class, ImmutableList.class);
        Configuration.putSafely(builder, Set.class, ImmutableSet.class);
        Configuration.putSafely(builder, SortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, Multiset.class, ImmutableMultiset.class);
        Configuration.putSafely(builder, ImmutableCollection.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableList.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableSet.class, ImmutableSet.class);
        Configuration.putSafely(builder, ImmutableSortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, ImmutableMultiset.class, ImmutableMultiset.class);
        COLLECTIONS = builder.buildOrThrow();
        DEFAULT_CONVERTERS = Collections.synchronizedMap(Configuration.createConverterMap());
        DEFAULT_CONVERTERS.put(Class.class, new ClassTypeConverter());
        DEFAULT_CONVERTERS.put(ClassOption.class, new ClassTypeConverter());
        DEFAULT_CONVERTERS.put(IntegerOption.class, new IntegerTypeConverter());
        DEFAULT_CONVERTERS.put(TimeSpanOption.class, new TimeSpanTypeConverter());
    }
}

