/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.io.MoreFiles;
import com.google.common.reflect.ClassPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sosy_lab.common.configuration.AutoValue_OptionCollector_OptionInfo;
import org.sosy_lab.common.configuration.AutoValue_OptionCollector_OptionsInfo;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionPlainTextWriter;
import org.sosy_lab.common.configuration.Options;

public final class OptionCollector {
    private static final String OPTIONS_FILE = "ConfigurationOptions.txt";
    private static final Pattern IGNORED_CLASSES = Pattern.compile("^org\\.sosy_lab\\.common\\..*Test(\\$.*)?$");
    private static final Pattern PATHS_PATTERN = Pattern.compile("Classes\\.getCodeLocation\\([^)]+\\)\\s*\\.resolve(Sibling)?\\((.*)\\)", 32);
    private static final Pattern IMMUTABLE_SET_PATTERN = Pattern.compile("ImmutableSet\\.(<.*>)?of\\((.*)\\)", 32);
    private static final Pattern IMMUTABLE_LIST_PATTERN = Pattern.compile("ImmutableList\\.(<.*>)?of\\((.*)\\)", 32);
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("SPDX-FileCopyrightText: .*");
    private static final Pattern LICENSE_PATTERN = Pattern.compile("SPDX-License-Identifier: .*");
    private final Set<String> errorMessages = Collections.synchronizedSet(new LinkedHashSet());
    private final LoadingCache<CodeSource, Path> codeSourceToSourcePath = CacheBuilder.newBuilder().initialCapacity(1).concurrencyLevel(1).build((CacheLoader)new CacheLoader<CodeSource, Path>(){

        public Path load(CodeSource codeSource) throws URISyntaxException {
            return OptionCollector.getSourcePath(codeSource);
        }
    });
    private final boolean verbose;
    private final boolean includeLibraryOptions;

    public static void main(String[] args) {
        boolean verbose = false;
        boolean includeLibraryOptions = false;
        String[] stringArray = args;
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-v": 
                case "-verbose": {
                    verbose = true;
                    continue block9;
                }
                case "-includeLibraryOptions": {
                    includeLibraryOptions = true;
                    continue block9;
                }
                default: {
                    System.err.println("Unexpected command-line argument: " + arg);
                    System.exit(1);
                }
            }
        }
        OptionCollector.collectOptions(verbose, includeLibraryOptions, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectOptions(boolean verbose, boolean includeLibraryOptions, PrintStream out) {
        OptionCollector optionCollector = new OptionCollector(verbose, includeLibraryOptions);
        try {
            optionCollector.collectOptions(out);
        }
        finally {
            optionCollector.errorMessages.forEach(System.err::println);
        }
    }

    private OptionCollector(boolean pVerbose, boolean pIncludeLibraryOptions) {
        this.verbose = pVerbose;
        this.includeLibraryOptions = pIncludeLibraryOptions;
    }

    private void collectOptions(PrintStream out) {
        ClassPath classPath;
        try {
            classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException e) {
            this.errorMessages.add("INFO: Could not scan class path for getting Option annotations: " + e.getMessage());
            return;
        }
        if (this.includeLibraryOptions) {
            this.copyOptionFilesToOutput(classPath, out);
        }
        Comparator<AnnotationInfo> annotationComparator = Comparator.comparing(a -> a.owningClass().getName());
        ConcurrentSkipListSet<String> copyrights = new ConcurrentSkipListSet<String>();
        ConcurrentSkipListSet<String> licenses = new ConcurrentSkipListSet<String>();
        NavigableMap<String, List<AnnotationInfo>> options = this.getClassesWithOptions(classPath).flatMap(c -> this.collectOptions((Class<?>)c, copyrights::add, licenses::add)).collect(OptionCollector.groupingBySorted(AnnotationInfo::name, Ordering.natural(), annotationComparator));
        OptionPlainTextWriter outputWriter = new OptionPlainTextWriter(this.verbose, out);
        outputWriter.writeHeader(copyrights, licenses);
        options.values().forEach(outputWriter::writeOption);
    }

    private void copyOptionFilesToOutput(ClassPath classPath, PrintStream out) {
        for (ClassPath.ResourceInfo resourceInfo : classPath.getResources()) {
            if (!new File(resourceInfo.getResourceName()).getName().equals(OPTIONS_FILE)) continue;
            try {
                resourceInfo.asCharSource(StandardCharsets.UTF_8).copyTo((Appendable)out);
                out.println();
            }
            catch (IOException e) {
                this.errorMessages.add("Could not find the required resource " + resourceInfo.url());
            }
        }
    }

    private Stream<Class<?>> getClassesWithOptions(ClassPath classPath) {
        return classPath.getAllClasses().parallelStream().filter(clsInfo -> clsInfo.url().getProtocol().equals("file")).filter(clsInfo -> !IGNORED_CLASSES.matcher(clsInfo.getName()).matches()).flatMap(this::tryLoadClass).filter(cls -> !Modifier.isInterface(cls.getModifiers())).filter(cls -> cls.isAnnotationPresent(Options.class));
    }

    private Stream<Class<?>> tryLoadClass(ClassPath.ClassInfo cls) {
        try {
            return Stream.of(cls.load());
        }
        catch (LinkageError e) {
            this.errorMessages.add(String.format("INFO: Could not load '%s' for getting Option annotations: %s: %s", cls.getResourceName(), e.getClass().getName(), e.getMessage()));
            return Stream.empty();
        }
    }

    private Stream<AnnotationInfo> collectOptions(Class<?> c, Consumer<String> addCopyright, Consumer<String> addLicense) {
        String optionName;
        Option option;
        Stream.Builder<AnnotationInfo> result = Stream.builder();
        String classSource = this.getSourceCode(c);
        COPYRIGHT_PATTERN.matcher(classSource).results().map(MatchResult::group).forEach(addCopyright);
        LICENSE_PATTERN.matcher(classSource).results().map(MatchResult::group).forEach(addLicense);
        Options classOption = c.getAnnotation(Options.class);
        Verify.verifyNotNull((Object)classOption, (String)"Class without @Options annotation", (Object[])new Object[0]);
        result.accept(OptionsInfo.create(c, classOption.prefix()));
        for (Field field : c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            option = field.getAnnotation(Option.class);
            optionName = Configuration.getOptionName(classOption, field, option);
            String defaultValue = OptionCollector.getDefaultValue(field, classSource);
            result.accept(OptionInfo.createForField(field, optionName, defaultValue));
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(Option.class)) continue;
            option = ((Method)accessibleObject).getAnnotation(Option.class);
            optionName = Configuration.getOptionName(classOption, (Member)((Object)accessibleObject), option);
            result.accept(OptionInfo.createForMethod((Method)accessibleObject, optionName));
        }
        return result.build();
    }

    private String getSourceCode(Class<?> cls) {
        Object filename = cls.getName().replace('.', File.separatorChar);
        if (((String)filename).contains("$")) {
            filename = ((String)filename).substring(0, ((String)filename).indexOf(36));
        }
        filename = (String)filename + ".java";
        try {
            Path path = (Path)this.codeSourceToSourcePath.get((Object)cls.getProtectionDomain().getCodeSource());
            return MoreFiles.asCharSource((Path)path.resolve((String)filename), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).read();
        }
        catch (IOException | ExecutionException e) {
            this.errorMessages.add("INFO: Could not find source files for classes in " + cls.getProtectionDomain().getCodeSource().getLocation());
            return "";
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static Path getSourcePath(CodeSource codeSource) throws URISyntaxException {
        Path basePath = Path.of(codeSource.getLocation().toURI());
        if (basePath.endsWith("bin")) {
            basePath = basePath.getParent();
        } else if (basePath.endsWith("build/classes/main")) {
            basePath = basePath.getParent().getParent().getParent();
        }
        ImmutableList candidates = ImmutableList.of((Object)Path.of("src", "main", "java"), (Object)Path.of("src", new String[0]));
        for (Path candidate : candidates) {
            Path sourcePath = basePath.resolve(candidate);
            if (!Files.isDirectory(sourcePath, new LinkOption[0])) continue;
            return sourcePath;
        }
        return basePath;
    }

    private static String getDefaultValue(Field field, String classSource) {
        String typeString = field.getGenericType().toString();
        if (typeString.matches(".*<.*>")) {
            typeString = typeString.replaceAll("^[^<]*\\.", "");
            typeString = typeString.replaceAll("<[^\\?][^<]*\\.", "<");
            typeString = typeString.replaceAll("<\\?[^<]*\\.", "<\\\\?\\\\s+extends\\\\s+");
        } else {
            typeString = field.getType().getSimpleName();
        }
        typeString = typeString.replaceAll("[^<>, ]*\\$([^<>, $]*)", "$1");
        String defaultValue = OptionCollector.getDefaultValueFromContent(classSource, OptionCollector.getFieldMatchingPattern(field, typeString));
        if (field.getType().isEnum()) {
            if (defaultValue.isEmpty()) {
                String type = field.getType().toString();
                type = type.substring(type.lastIndexOf(46) + 1).replace("$", ".");
                defaultValue = OptionCollector.getDefaultValueFromContent(classSource, OptionCollector.getFieldMatchingPattern(field, type));
            }
            if (defaultValue.contains(".")) {
                defaultValue = defaultValue.substring(defaultValue.lastIndexOf(46) + 1);
            }
        }
        if (defaultValue.equals("null")) {
            defaultValue = "";
        }
        return defaultValue;
    }

    private static String getFieldMatchingPattern(Field field, String type) {
        return Modifier.toString(field.getModifiers()) + "\\s+" + type + "\\s+" + field.getName();
    }

    private static String getDefaultValueFromContent(String content, String fieldPattern) {
        Object defaultValue = "";
        List splitted = Splitter.onPattern((String)fieldPattern).splitToList((CharSequence)content);
        if (splitted.size() > 1) {
            String rest = (String)splitted.get(1);
            defaultValue = rest.substring(0, rest.indexOf(59)).trim();
            if (((String)defaultValue).startsWith("=")) {
                Matcher match;
                defaultValue = ((String)defaultValue).substring(1).trim();
                while (((String)defaultValue).contains("/*")) {
                    defaultValue = ((String)defaultValue).substring(0, ((String)defaultValue).indexOf("/*")) + ((String)defaultValue).substring(((String)defaultValue).indexOf("*/") + 2);
                }
                if (((String)defaultValue).contains("//")) {
                    defaultValue = ((String)defaultValue).substring(0, ((String)defaultValue).indexOf("//"));
                }
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "new File");
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "Paths.get");
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "Path.of");
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "new Path");
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "Pattern.compile");
                defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "PathTemplate.ofFormatString");
                if (((String)(defaultValue = OptionCollector.stripSurroundingFunctionCall((String)defaultValue, "PathCounterTemplate.ofFormatString"))).startsWith("TimeSpan.ofNanos(")) {
                    defaultValue = ((String)defaultValue).substring("TimeSpan.ofNanos(".length(), ((String)defaultValue).length() - 1) + "ns";
                }
                if (((String)defaultValue).startsWith("TimeSpan.ofMillis(")) {
                    defaultValue = ((String)defaultValue).substring("TimeSpan.ofMillis(".length(), ((String)defaultValue).length() - 1) + "ms";
                }
                if (((String)defaultValue).startsWith("TimeSpan.ofSeconds(")) {
                    defaultValue = ((String)defaultValue).substring("TimeSpan.ofSeconds(".length(), ((String)defaultValue).length() - 1) + "s";
                }
                if ((match = IMMUTABLE_SET_PATTERN.matcher((CharSequence)defaultValue)).matches()) {
                    defaultValue = "{" + match.group(2) + "}";
                }
                if ((match = IMMUTABLE_LIST_PATTERN.matcher((CharSequence)defaultValue)).matches()) {
                    defaultValue = "[" + match.group(2) + "]";
                }
                if ((match = PATHS_PATTERN.matcher((CharSequence)defaultValue)).matches()) {
                    defaultValue = match.group(2);
                }
            }
        } else {
            String stringSetFieldPattern = fieldPattern.replace("\\s+Set\\s+", "\\s+Set<String>\\s+");
            if (content.contains(stringSetFieldPattern)) {
                return OptionCollector.getDefaultValueFromContent(content, stringSetFieldPattern);
            }
        }
        return ((String)defaultValue).trim();
    }

    private static String stripSurroundingFunctionCall(String s, String partToBeStripped) {
        String toBeStripped = partToBeStripped + "(";
        if (s.startsWith(toBeStripped)) {
            return s.substring(toBeStripped.length(), s.length() - 1);
        }
        return s;
    }

    private static <T, K> Collector<T, ?, NavigableMap<K, List<T>>> groupingBySorted(Function<? super T, ? extends K> classifier, Comparator<? super K> keyComparator, Comparator<? super T> valueComparator) {
        Function<List, List> listSortFinisher = list -> {
            list.sort(valueComparator);
            return list;
        };
        Collector toSortedList = Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), listSortFinisher);
        return Collectors.groupingBy(classifier, () -> new TreeMap(keyComparator), toSortedList);
    }

    @AutoValue
    static abstract class OptionsInfo
    extends AnnotationInfo {
        OptionsInfo() {
        }

        static OptionsInfo create(Class<?> c, String prefix) {
            return new AutoValue_OptionCollector_OptionsInfo(prefix, c);
        }

        @Override
        abstract Class<?> element();

        @Override
        final Class<?> owningClass() {
            return this.element();
        }
    }

    @AutoValue
    static abstract class OptionInfo
    extends AnnotationInfo {
        OptionInfo() {
        }

        static OptionInfo createForField(Field field, String name, String defaultValue) {
            return new AutoValue_OptionCollector_OptionInfo(field, name, field.getType(), defaultValue);
        }

        static OptionInfo createForMethod(Method method, String name) {
            return new AutoValue_OptionCollector_OptionInfo(method, name, method.getReturnType(), "");
        }

        abstract Class<?> type();

        abstract String defaultValue();

        @Override
        final Class<?> owningClass() {
            return ((Member)((Object)this.element())).getDeclaringClass();
        }
    }

    static abstract class AnnotationInfo {
        AnnotationInfo() {
        }

        abstract AnnotatedElement element();

        abstract String name();

        abstract Class<?> owningClass();
    }
}

