/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NavigableSet;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;

class OptionPlainTextWriter {
    private static final String COMMENT_PREFIX = "# ";
    private static final int CHARS_PER_LINE = 75;
    private final boolean verbose;
    private final PrintStream out;
    private String lastDescription = "";
    private String lastInfo = "";

    OptionPlainTextWriter(boolean pVerbose, PrintStream pOut) {
        this.verbose = pVerbose;
        this.out = (PrintStream)Preconditions.checkNotNull((Object)pOut);
    }

    void writeHeader(NavigableSet<String> copyrights, NavigableSet<String> licenses) {
        for (String s : copyrights) {
            this.out.append(COMMENT_PREFIX).println(s);
        }
        if (!copyrights.isEmpty() && !licenses.isEmpty()) {
            this.out.println(COMMENT_PREFIX.stripTrailing());
        }
        for (String s : licenses) {
            this.out.append(COMMENT_PREFIX).println(s);
        }
    }

    void writeOption(Iterable<OptionCollector.AnnotationInfo> allInstances) {
        boolean first = true;
        for (OptionCollector.AnnotationInfo annotation : allInstances) {
            String description = OptionPlainTextWriter.getOptionDescription(annotation.element());
            if (description.isEmpty() || this.lastDescription.equals(description)) continue;
            if (first) {
                this.out.append('\n');
                first = false;
            }
            this.out.append(description);
            this.lastDescription = description;
        }
        for (OptionCollector.OptionInfo option : FluentIterable.from(allInstances).filter(OptionCollector.OptionInfo.class)) {
            String infoText = this.getOptionInfo(option);
            if (this.lastInfo.equals(infoText)) continue;
            this.out.append(infoText);
            this.lastInfo = infoText;
        }
    }

    static String getOptionDescription(AnnotatedElement element) {
        Object text;
        if (element.isAnnotationPresent(Option.class)) {
            text = element.getAnnotation(Option.class).description();
        } else if (element.isAnnotationPresent(Options.class)) {
            text = element.getAnnotation(Options.class).description();
        } else {
            throw new AssertionError();
        }
        if (element.isAnnotationPresent(Deprecated.class)) {
            text = "DEPRECATED: " + (String)text;
        }
        return OptionPlainTextWriter.formatText((String)text);
    }

    private String getOptionInfo(OptionCollector.OptionInfo info) {
        StringBuilder optionInfo = new StringBuilder(200);
        optionInfo.append(info.name());
        if (this.verbose) {
            if (info.element() instanceof Field) {
                optionInfo.append("\n  field:    ").append(((Field)info.element()).getName()).append('\n');
            } else if (info.element() instanceof Method) {
                optionInfo.append("\n  method:   ").append(((Method)info.element()).getName()).append('\n');
            }
            Class<?> cls = ((Member)((Object)info.element())).getDeclaringClass();
            optionInfo.append("  class:    ").append(cls.toString().substring(6)).append("\n  type:     ").append(info.type().getSimpleName()).append("\n  default value: ");
            if (!info.defaultValue().isEmpty()) {
                optionInfo.append(info.defaultValue());
            } else {
                optionInfo.append("not available");
            }
        } else if (!info.defaultValue().isEmpty()) {
            optionInfo.append(" = ").append(info.defaultValue());
        } else {
            optionInfo.append(" = no default value");
        }
        optionInfo.append('\n');
        this.appendAllowedValues(info.element(), info.type(), optionInfo);
        return optionInfo.toString();
    }

    private static String formatText(String text) {
        return OptionPlainTextWriter.formatText(text, COMMENT_PREFIX, true);
    }

    private static String formatText(String text, String lineStart, boolean useLineStartInFirstLine) {
        Preconditions.checkNotNull((Object)lineStart);
        if (text.isEmpty()) {
            return text;
        }
        ArrayList<String> splittedLines = new ArrayList<String>();
        Iterator iterator = Splitter.on((char)'\n').split((CharSequence)text).iterator();
        while (iterator.hasNext()) {
            String fullLine;
            String remainingLine = fullLine = (String)iterator.next();
            while (remainingLine.length() > 75) {
                String start;
                int spaceIndex = remainingLine.lastIndexOf(32, 75);
                if (spaceIndex == -1) {
                    spaceIndex = remainingLine.indexOf(32);
                }
                if (spaceIndex == -1) {
                    spaceIndex = remainingLine.length() - 1;
                }
                if (!(start = remainingLine.substring(0, spaceIndex)).isEmpty()) {
                    splittedLines.add(start);
                }
                remainingLine = remainingLine.substring(spaceIndex + 1);
            }
            splittedLines.add(remainingLine);
        }
        if (((String)splittedLines.get(splittedLines.size() - 1)).isEmpty()) {
            splittedLines.remove(splittedLines.size() - 1);
        }
        StringBuilder formattedLines = new StringBuilder();
        if (!useLineStartInFirstLine && !splittedLines.isEmpty()) {
            formattedLines.append((String)splittedLines.remove(0));
            formattedLines.append('\n');
        }
        for (String line : splittedLines) {
            formattedLines.append(lineStart);
            formattedLines.append(line);
            formattedLines.append('\n');
        }
        return formattedLines.toString();
    }

    private void appendAllowedValues(AnnotatedElement field, Class<?> type, StringBuilder str) {
        if (type.isEnum()) {
            ?[] enums = type.getEnumConstants();
            Object[] enumTitles = new String[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                enumTitles[i] = ((Enum)enums[i]).name();
            }
            str.append("  enum:     ").append(OptionPlainTextWriter.formatText(Arrays.toString(enumTitles), "             ", false));
        }
        this.appendOptionValues(field, str);
        this.appendClassOptionValues(field, str);
        this.appendFileOptionValues(field, str);
        this.appendIntegerOptionValues(field, str);
        this.appendTimeSpanOptionValues(field, str);
    }

    private void appendOptionValues(AnnotatedElement field, StringBuilder str) {
        Option option = field.getAnnotation(Option.class);
        assert (option != null);
        if (option.values().length != 0) {
            str.append("  allowed values: ").append(Arrays.toString(option.values())).append('\n');
        }
        if (this.verbose) {
            if (!option.regexp().isEmpty()) {
                str.append("  regexp:   ").append(option.regexp()).append('\n');
            }
            if (option.toUppercase()) {
                str.append("  uppercase: true\n");
            }
        }
    }

    private void appendClassOptionValues(AnnotatedElement field, StringBuilder str) {
        ClassOption classOption = field.getAnnotation(ClassOption.class);
        if (classOption != null && this.verbose && classOption.packagePrefix().length != 0) {
            str.append("  packagePrefix: ");
            Joiner.on((String)", ").appendTo(str, (Object[])classOption.packagePrefix());
            str.append('\n');
        }
    }

    private void appendFileOptionValues(AnnotatedElement field, StringBuilder str) {
        FileOption fileOption = field.getAnnotation(FileOption.class);
        if (fileOption != null && this.verbose) {
            str.append("  type of file: ").append((Object)fileOption.value()).append('\n');
        }
    }

    private void appendIntegerOptionValues(AnnotatedElement field, StringBuilder str) {
        IntegerOption intOption = field.getAnnotation(IntegerOption.class);
        if (intOption != null && this.verbose) {
            if (intOption.min() == Long.MIN_VALUE) {
                str.append("  min:      Long.MIN_VALUE\n");
            } else {
                str.append("  min:      ").append(intOption.min()).append('\n');
            }
            if (intOption.max() == Long.MAX_VALUE) {
                str.append("  max:      Long.MAX_VALUE\n");
            } else {
                str.append("  max:      ").append(intOption.max()).append('\n');
            }
        }
    }

    private void appendTimeSpanOptionValues(AnnotatedElement field, StringBuilder str) {
        TimeSpanOption timeSpanOption = field.getAnnotation(TimeSpanOption.class);
        if (timeSpanOption != null && this.verbose) {
            str.append("  code unit:     ").append((Object)timeSpanOption.codeUnit()).append("\n  default unit:  ").append((Object)timeSpanOption.defaultUserUnit()).append('\n');
            if (timeSpanOption.min() == Long.MIN_VALUE) {
                str.append("  time min:      Long.MIN_VALUE\n");
            } else {
                str.append("  time min:      ").append(timeSpanOption.min()).append('\n');
            }
            if (timeSpanOption.max() == Long.MAX_VALUE) {
                str.append("  time max:      Long.MAX_VALUE\n");
            } else {
                str.append("  time max:      ").append(timeSpanOption.max()).append('\n');
            }
        }
    }
}

