/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.collect.FluentIterable;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Collections;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;

public class ClassTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String optionName, String value, TypeToken<?> type, Annotation secondaryOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Object result;
        FluentIterable packagePrefixes = Collections.singleton(null);
        if (secondaryOption != null) {
            if (!(secondaryOption instanceof ClassOption)) {
                throw new UnsupportedOperationException("Options of type Class may not be annotated with " + secondaryOption);
            }
            packagePrefixes = FluentIterable.from(packagePrefixes).append((Object[])((ClassOption)secondaryOption).packagePrefix());
        }
        Class<?> cls = null;
        for (String prefix : packagePrefixes) {
            try {
                cls = Classes.forName(value, prefix);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (cls == null) {
            throw new InvalidConfigurationException("Class " + value + " specified in option " + optionName + " not found");
        }
        if (type.getRawType().equals(Class.class)) {
            TypeToken<?> targetType = Classes.getSingleTypeArgument(type);
            if (!targetType.isSupertypeOf(cls)) {
                throw new InvalidConfigurationException(String.format("Class %s specified in option %s is not an instance of %s", value, optionName, targetType));
            }
            result = cls;
            Classes.produceClassLoadingWarning(logger, cls, targetType.getRawType());
        } else {
            try {
                result = Classes.createFactory(type, cls);
            }
            catch (Classes.UnsuitedClassException e) {
                throw new InvalidConfigurationException(String.format("Class %s specified in option %s is invalid (%s)", value, optionName, e.getMessage()));
            }
            Classes.produceClassLoadingWarning(logger, cls, type.getRawType());
        }
        return result;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, TypeToken<T> pType, Annotation pSecondaryOption) {
        return pValue;
    }
}

