/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.nio.file.Path;
import java.util.Arrays;

@Immutable
public final class PathTemplate {
    private final String template;

    private PathTemplate(String pTemplate) {
        Preconditions.checkArgument((!pTemplate.isEmpty() ? 1 : 0) != 0);
        this.template = pTemplate;
    }

    public static PathTemplate ofFormatString(String pTemplate) {
        return new PathTemplate(pTemplate);
    }

    public Path getPath(Object ... args) {
        Preconditions.checkArgument((!Arrays.asList(args).contains(null) ? 1 : 0) != 0, (Object)"Values for PathTemplate may not be null");
        return Path.of(String.format(this.template, args), new String[0]);
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("template", (Object)this.template).toString();
    }
}

