/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

abstract class AbstractColoredLogFormatter
extends Formatter {
    private final boolean useColors;

    protected AbstractColoredLogFormatter(@Var boolean pUseColors) {
        if (pUseColors && (System.console() == null || System.getProperty("os.name", "").startsWith("Windows") || System.getenv("NO_COLOR") != null)) {
            pUseColors = false;
        }
        this.useColors = pUseColors;
    }

    @Override
    public final String format(LogRecord lr) {
        StringBuilder sb = new StringBuilder(200);
        if (this.useColors) {
            if (lr.getLevel().equals(Level.WARNING)) {
                sb.append("\u001b[1m");
            } else if (lr.getLevel().equals(Level.SEVERE)) {
                sb.append("\u001b[31;1m");
            }
        }
        this.format(lr, sb);
        if (this.useColors) {
            sb.append("\u001b[m");
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("useColors", this.useColors).toString();
    }

    protected abstract void format(LogRecord var1, StringBuilder var2);
}

