/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.sosy_lab.common.log.AbstractColoredLogFormatter;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.LogUtils;
import org.sosy_lab.common.log.LoggingOptions;

public class ConsoleLogFormatter
extends AbstractColoredLogFormatter {
    public ConsoleLogFormatter(LoggingOptions options) {
        this(options.useColors());
    }

    private ConsoleLogFormatter(boolean useColors) {
        super(useColors);
    }

    public static Formatter withoutColors() {
        return new ConsoleLogFormatter(false);
    }

    public static Formatter withColorsIfPossible() {
        return new ConsoleLogFormatter(true);
    }

    @Override
    protected void format(LogRecord lr, StringBuilder sb) {
        String component;
        sb.append(lr.getMessage()).append(" (");
        if (lr instanceof ExtendedLogRecord && !(component = ((ExtendedLogRecord)lr).getSourceComponentName()).isEmpty()) {
            sb.append(component).append(':');
        }
        sb.append(Objects.requireNonNullElse(LogUtils.extractSimpleClassName(lr), "$Unknown$")).append('.').append(Objects.requireNonNullElse(lr.getSourceMethodName(), "$unknown$")).append(", ").append(lr.getLevel().toString()).append(')');
        sb.append("\n\n");
    }
}

