/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

class StatisticsBooleanFormulaManager
implements BooleanFormulaManager {
    private final BooleanFormulaManager delegate;
    private final SolverStatistics stats;

    StatisticsBooleanFormulaManager(BooleanFormulaManager pDelegate, SolverStatistics pStats) {
        this.delegate = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public BooleanFormula makeTrue() {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.makeTrue();
    }

    @Override
    public BooleanFormula makeFalse() {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.makeFalse();
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.makeVariable(pVar);
    }

    @Override
    public BooleanFormula equivalence(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.equivalence(pFormula1, pFormula2);
    }

    @Override
    public BooleanFormula implication(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.implication(pFormula1, pFormula2);
    }

    @Override
    public boolean isTrue(BooleanFormula pFormula) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.isTrue(pFormula);
    }

    @Override
    public boolean isFalse(BooleanFormula pFormula) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.isFalse(pFormula);
    }

    @Override
    public <T extends Formula> T ifThenElse(BooleanFormula pCond, T pF1, T pF2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.ifThenElse(pCond, pF1, pF2);
    }

    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.not(pBits);
    }

    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.and(pBits1, pBits2);
    }

    @Override
    public BooleanFormula and(Collection<BooleanFormula> pBits) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.and(pBits);
    }

    @Override
    public BooleanFormula and(BooleanFormula ... pBits) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.and(pBits);
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::and);
    }

    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.or(pBits1, pBits2);
    }

    @Override
    public BooleanFormula or(Collection<BooleanFormula> pBits) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.or(pBits);
    }

    @Override
    public BooleanFormula or(BooleanFormula ... pBits) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.or(pBits);
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::or);
    }

    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        this.stats.booleanOperations.getAndIncrement();
        return this.delegate.xor(pBits1, pBits2);
    }

    @Override
    public <R> R visit(BooleanFormula pFormula, BooleanFormulaVisitor<R> pVisitor) {
        this.stats.visits.getAndIncrement();
        return this.delegate.visit(pFormula, pVisitor);
    }

    @Override
    public void visitRecursively(BooleanFormula pF, BooleanFormulaVisitor<TraversalProcess> pRFormulaVisitor) {
        this.stats.visits.getAndIncrement();
        this.delegate.visitRecursively(pF, pRFormulaVisitor);
    }

    @Override
    public BooleanFormula transformRecursively(BooleanFormula pF, BooleanFormulaTransformationVisitor pVisitor) {
        this.stats.visits.getAndIncrement();
        return this.delegate.transformRecursively(pF, pVisitor);
    }

    @Override
    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula pF, boolean pFlatten) {
        return this.delegate.toConjunctionArgs(pF, pFlatten);
    }

    @Override
    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula pF, boolean pFlatten) {
        return this.delegate.toDisjunctionArgs(pF, pFlatten);
    }
}

