/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

class StatisticsNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
implements NumeralFormulaManager<ParamFormulaType, ResultFormulaType> {
    private final NumeralFormulaManager<ParamFormulaType, ResultFormulaType> delegate;
    final SolverStatistics stats;

    StatisticsNumeralFormulaManager(NumeralFormulaManager<ParamFormulaType, ResultFormulaType> pDelegate, SolverStatistics pStats) {
        this.delegate = (NumeralFormulaManager)Preconditions.checkNotNull(pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public ResultFormulaType makeNumber(long pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pNumber);
    }

    @Override
    public ResultFormulaType makeNumber(BigInteger pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pNumber);
    }

    @Override
    public ResultFormulaType makeNumber(double pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pNumber);
    }

    @Override
    public ResultFormulaType makeNumber(BigDecimal pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pNumber);
    }

    @Override
    public ResultFormulaType makeNumber(String pI) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pI);
    }

    @Override
    public ResultFormulaType makeNumber(Rational pRational) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeNumber(pRational);
    }

    @Override
    public ResultFormulaType makeVariable(String pVar) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.makeVariable(pVar);
    }

    @Override
    public FormulaType<ResultFormulaType> getFormulaType() {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.getFormulaType();
    }

    @Override
    public ResultFormulaType negate(ParamFormulaType pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.negate(pNumber);
    }

    @Override
    public ResultFormulaType add(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.add(pNumber1, pNumber2);
    }

    @Override
    public ResultFormulaType sum(List<ParamFormulaType> pOperands) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.sum(pOperands);
    }

    @Override
    public ResultFormulaType subtract(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.subtract(pNumber1, pNumber2);
    }

    @Override
    public ResultFormulaType divide(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.divide(pNumber1, pNumber2);
    }

    @Override
    public ResultFormulaType multiply(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.multiply(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula equal(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.equal(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula distinct(List<ParamFormulaType> pNumbers) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.distinct(pNumbers);
    }

    @Override
    public BooleanFormula greaterThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.greaterThan(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula greaterOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.greaterOrEquals(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula lessThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.lessThan(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula lessOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.lessOrEquals(pNumber1, pNumber2);
    }

    @Override
    public NumeralFormula.IntegerFormula floor(ParamFormulaType pNumber) {
        this.stats.numericOperations.getAndIncrement();
        return this.delegate.floor(pNumber);
    }
}

