/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsInterpolatingProverEnvironment;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsOptimizationProverEnvironment;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsProverEnvironment;

public class StatisticsSolverContext
implements SolverContext {
    private final SolverContext delegate;
    private final SolverStatistics stats = new SolverStatistics();

    public StatisticsSolverContext(SolverContext pDelegate) {
        this.delegate = (SolverContext)Preconditions.checkNotNull((Object)pDelegate);
    }

    @Override
    public FormulaManager getFormulaManager() {
        return new StatisticsFormulaManager(this.delegate.getFormulaManager(), this.stats);
    }

    @Override
    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        return new StatisticsProverEnvironment(this.delegate.newProverEnvironment(pOptions), this.stats);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(SolverContext.ProverOptions ... pOptions) {
        return new StatisticsInterpolatingProverEnvironment(this.delegate.newProverEnvironmentWithInterpolation(pOptions), this.stats);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        return new StatisticsOptimizationProverEnvironment(this.delegate.newOptimizationProverEnvironment(pOptions), this.stats);
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return this.delegate.getSolverName();
    }

    @Override
    public ImmutableMap<String, String> getStatistics() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.delegate.getStatistics());
        for (Map.Entry entry : this.getSolverStatistics().asMap().entrySet()) {
            builder.put((Object)((String)entry.getKey()), (Object)entry.getValue().toString());
        }
        return builder.buildOrThrow();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public SolverStatistics getSolverStatistics() {
        return this.stats;
    }
}

