/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

class SynchronizedBooleanFormulaManager
implements BooleanFormulaManager {
    private final BooleanFormulaManager delegate;
    private final SolverContext sync;
    private final BooleanFormula tru;
    private final BooleanFormula fls;

    SynchronizedBooleanFormulaManager(BooleanFormulaManager pDelegate, SolverContext pSync) {
        this.delegate = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
        this.tru = this.delegate.makeTrue();
        this.fls = this.delegate.makeFalse();
    }

    @Override
    public BooleanFormula makeTrue() {
        return this.tru;
    }

    @Override
    public BooleanFormula makeFalse() {
        return this.fls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula makeVariable(String pVar) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeVariable(pVar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula equivalence(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.equivalence(pFormula1, pFormula2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula implication(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.implication(pFormula1, pFormula2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrue(BooleanFormula pFormula) {
        if (pFormula == this.tru) {
            return true;
        }
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.isTrue(pFormula);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFalse(BooleanFormula pFormula) {
        if (pFormula == this.fls) {
            return true;
        }
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.isFalse(pFormula);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T ifThenElse(BooleanFormula pCond, T pF1, T pF2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.ifThenElse(pCond, pF1, pF2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.not(pBits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.and(pBits1, pBits2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula and(Collection<BooleanFormula> pBits) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.and(pBits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula and(BooleanFormula ... pBits) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.and(pBits);
        }
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::and);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.or(pBits1, pBits2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula or(Collection<BooleanFormula> pBits) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.or(pBits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula or(BooleanFormula ... pBits) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.or(pBits);
        }
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::or);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.xor(pBits1, pBits2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R visit(BooleanFormula pFormula, BooleanFormulaVisitor<R> pVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.visit(pFormula, pVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRecursively(BooleanFormula pF, BooleanFormulaVisitor<TraversalProcess> pRFormulaVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.visitRecursively(pF, pRFormulaVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula transformRecursively(BooleanFormula pF, BooleanFormulaTransformationVisitor pVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.transformRecursively(pF, pVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula pF, boolean pFlatten) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.toConjunctionArgs(pF, pFlatten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula pF, boolean pFlatten) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.toDisjunctionArgs(pF, pFlatten);
        }
    }
}

