/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class SolverOverviewTable {
    public static void main(String[] args) throws SolverException, InterruptedException {
        ArrayList<SolverInfo> infos = new ArrayList<SolverInfo>();
        for (SolverContextFactory.Solvers s : SolverContextFactory.Solvers.values()) {
            infos.add(new SolverOverviewTable().getSolverInformation(s));
        }
        infos.sort(Comparator.comparing(SolverInfo::getName));
        RowBuilder rowBuilder = new RowBuilder();
        for (SolverInfo info : infos) {
            rowBuilder.addSolver(info);
        }
        System.out.println(rowBuilder);
    }

    public @Nullable SolverInfo getSolverInformation(SolverContextFactory.Solvers solver) throws SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = LogManager.createNullLogManager();
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
        try {
            String version = context.getVersion();
            String theories = String.join((CharSequence)", ", this.getTheories(context));
            String features = String.join((CharSequence)", ", this.getFeatures(context));
            SolverInfo solverInfo = new SolverInfo(solver, version, theories, features);
            if (context != null) {
                context.close();
            }
            return solverInfo;
        }
        catch (Throwable throwable) {
            try {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InvalidConfigurationException e) {
                return new SolverInfo(solver, "NOT AVAILABLE", "", "");
            }
        }
    }

    private List<String> getFeatures(SolverContext context) throws SolverException, InterruptedException {
        BasicProverEnvironment<Void> prover2;
        ArrayList<String> features = new ArrayList<String>();
        try {
            prover2 = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);
            try {
                Preconditions.checkNotNull((Object)prover2);
                features.add("Optimization");
            }
            finally {
                if (prover2 != null) {
                    prover2.close();
                }
            }
        }
        catch (UnsupportedOperationException prover2) {
            // empty catch block
        }
        try {
            prover2 = context.newProverEnvironmentWithInterpolation(SolverContext.ProverOptions.GENERATE_MODELS);
            try {
                Preconditions.checkNotNull((Object)prover2);
                features.add("Interpolation");
            }
            finally {
                if (prover2 != null) {
                    prover2.close();
                }
            }
        }
        catch (UnsupportedOperationException prover3) {
            // empty catch block
        }
        prover2 = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);
        try {
            try {
                prover2.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of());
                features.add("Assumptions");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            if (prover2 != null) {
                prover2.close();
            }
        }
        try {
            prover2 = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);
            try {
                prover2.unsatCoreOverAssumptions((Collection<BooleanFormula>)ImmutableList.of());
                features.add("UnsatCore /w Assumption");
            }
            finally {
                if (prover2 != null) {
                    prover2.close();
                }
            }
        }
        catch (UnsupportedOperationException prover2) {
            // empty catch block
        }
        try {
            prover2 = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            try {
                prover2.push(context.getFormulaManager().getBooleanFormulaManager().makeFalse());
                Preconditions.checkState((boolean)prover2.isUnsat());
                Preconditions.checkNotNull(prover2.getUnsatCore());
                features.add("UnsatCore");
            }
            finally {
                if (prover2 != null) {
                    prover2.close();
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return features;
    }

    private List<String> getTheories(SolverContext context) {
        ArrayList<String> theories = new ArrayList<String>();
        FormulaManager mgr = context.getFormulaManager();
        this.addIfAvailable(theories, mgr::getIntegerFormulaManager, "Integer");
        this.addIfAvailable(theories, mgr::getBitvectorFormulaManager, "Bitvector");
        this.addIfAvailable(theories, mgr::getRationalFormulaManager, "Rational");
        this.addIfAvailable(theories, mgr::getFloatingPointFormulaManager, "Float");
        this.addIfAvailable(theories, mgr::getArrayFormulaManager, "Array");
        this.addIfAvailable(theories, mgr::getQuantifiedFormulaManager, "Quantifier");
        this.addIfAvailable(theories, mgr::getUFManager, "UF");
        this.addIfAvailable(theories, mgr::getSLFormulaManager, "Seperation-Logic");
        this.addIfAvailable(theories, mgr::getStringFormulaManager, "String");
        return theories;
    }

    private void addIfAvailable(List<String> names, Supplier<Object> creator, String name) {
        try {
            if (creator.get() != null) {
                names.add(name);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static class RowBuilder {
        private final List<String> lines = new ArrayList<String>();
        private static final int MIN_NUM_OF_LINES = 4;
        private static final int SOLVER_COLUMN_WIDTH = 11;
        private static final int VERSION_COLUMN_WIDTH = 38;
        private static final int THEORIES_COLUMN_WIDTH = 30;
        private static final int FEATURES_COLUMN_WIDTH = 30;
        private static final String INFO_COLUMN = "| %-11s | %-38s | %-30s | %-30s |%n";
        private static final String SEPERATOR_LINE = "+-" + "-".repeat(11) + "-+-" + "-".repeat(38) + "-+-" + "-".repeat(30) + "-+-" + "-".repeat(30) + "-+" + System.lineSeparator();

        public RowBuilder() {
            this.lines.add(SEPERATOR_LINE);
            this.lines.add(String.format(INFO_COLUMN, "Solver", "Version", "Theories", "Features"));
            this.lines.add(SEPERATOR_LINE);
        }

        public void addSolver(SolverInfo solverInfo) {
            ArrayList nameLines = Lists.newArrayList((Object[])new String[]{solverInfo.getName()});
            List<String> versionLines = this.formatLines(solverInfo.getVersion(), 38);
            List<String> theoriesLines = this.formatLines(solverInfo.getTheories(), 30);
            List<String> featuresLines = this.formatLines(solverInfo.getFeatures(), 30);
            int maxLines = Math.max(Math.max(versionLines.size(), theoriesLines.size()), featuresLines.size());
            this.padLines(nameLines, maxLines);
            this.padLines(versionLines, maxLines);
            this.padLines(theoriesLines, maxLines);
            this.padLines(featuresLines, maxLines);
            for (int i = 0; i < maxLines; ++i) {
                String nameL = (String)nameLines.get(i);
                String versionL = versionLines.get(i);
                String theoriesL = theoriesLines.get(i);
                String featuresL = featuresLines.get(i);
                this.lines.add(String.format(INFO_COLUMN, nameL, versionL, theoriesL, featuresL));
            }
            this.lines.add(SEPERATOR_LINE);
        }

        private void padLines(List<String> linesToPad, int amountOfLines) {
            int numMissingLines = amountOfLines - linesToPad.size();
            for (int i = 0; i < numMissingLines; ++i) {
                linesToPad.add("");
            }
        }

        private List<String> formatLines(String lineToSplit, int maxLength) {
            List versionSplit = Splitter.on((String)" ").splitToList((CharSequence)lineToSplit);
            ArrayList<String> versionLines = new ArrayList<String>();
            Object line = (String)versionSplit.get(0);
            int lineCounter = ((String)line).length();
            for (String current : Iterables.skip((Iterable)versionSplit, (int)1)) {
                if ((lineCounter += current.length() + 1) > maxLength) {
                    lineCounter = current.length() + 1;
                    versionLines.add((String)line);
                    line = current;
                    continue;
                }
                line = (String)line + " " + current;
            }
            versionLines.add((String)line);
            return versionLines;
        }

        public String toString() {
            if (this.lines.size() < 3) {
                return "Could not find any installed SMT-Solvers.";
            }
            return String.join((CharSequence)"", this.lines);
        }
    }

    public static class SolverInfo {
        private final SolverContextFactory.Solvers solver;
        private final String solverVersion;
        private final String solverTheories;
        private final String solverFeatures;

        SolverInfo(SolverContextFactory.Solvers solver, String solverVersion, String solverTheories, String solverFeatures) {
            this.solver = solver;
            this.solverVersion = solverVersion;
            this.solverTheories = solverTheories;
            this.solverFeatures = solverFeatures;
        }

        public String getName() {
            return this.solver.name();
        }

        public String getVersion() {
            return this.solverVersion;
        }

        public String getTheories() {
            return this.solverTheories;
        }

        public String getFeatures() {
            return this.solverFeatures;
        }
    }
}

