/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5NumeralFormulaManager;

public class CVC5IntegerFormulaManager
extends CVC5NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    CVC5IntegerFormulaManager(CVC5FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected Sort getNumeralType() {
        return (Sort)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return (Term)this.decimalAsInteger(pNumber);
    }

    @Override
    public Term divide(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.INTS_DIVISION, pParam1, pParam2);
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, long pModulo) {
        return this.modularCongruence(pNumber1, pNumber2, BigInteger.valueOf(pModulo));
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, BigInteger pModulo) {
        if (BigInteger.ZERO.compareTo(pModulo) < 0) {
            Term n = this.makeNumberImpl(pModulo);
            Term x = this.subtract(pNumber1, pNumber2);
            return this.solver.mkTerm(Kind.EQUAL, x, this.solver.mkTerm(Kind.MULT, n, this.solver.mkTerm(Kind.INTS_DIVISION, x, n)));
        }
        return this.solver.mkBoolean(true);
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        if (!INTEGER_NUMBER.matcher(pI).matches()) {
            throw new NumberFormatException("Number is not an integer value: " + pI);
        }
        try {
            return this.solver.mkInteger(pI);
        }
        catch (CVC5ApiException e) {
            throw new NumberFormatException("Number is not an integer value: " + pI);
        }
    }

    @Override
    protected Term makeVariableImpl(String pI) {
        return (Term)this.formulaCreator.makeVariable((Sort)this.getFormulaCreator().getIntegerType(), pI);
    }
}

