/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

class SmtInterpolModel
extends AbstractModel.CachingAbstractModel<Term, Sort, Script> {
    private final Model model;
    private final Script env;
    private final ImmutableList<Term> assertedTerms;

    SmtInterpolModel(Model pModel, FormulaCreator<Term, Sort, Script, ?> pCreator, Collection<Term> pAssertedTerms) {
        super(pCreator);
        this.model = pModel;
        this.env = pCreator.getEnv();
        this.assertedTerms = ImmutableList.copyOf(pAssertedTerms);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        LinkedHashSet<FunctionSymbol> usedSymbols = new LinkedHashSet<FunctionSymbol>();
        for (Term assertedTerm : this.assertedTerms) {
            for (Term symbol : this.creator.extractVariablesAndUFs(assertedTerm, true).values()) {
                if (!(symbol instanceof ApplicationTerm)) continue;
                usedSymbols.add(((ApplicationTerm)symbol).getFunction());
            }
        }
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (FunctionSymbol symbol : this.model.getDefinedFunctions()) {
            if (!usedSymbols.contains(symbol)) continue;
            String name = SmtInterpolModel.unescape(symbol.getApplicationString());
            if (symbol.getParameterSorts().length == 0) {
                Term variable = this.env.term(name, new Term[0]);
                if (symbol.getReturnSort().isArraySort()) {
                    assignments.addAll(this.getArrayAssignment(name, variable, variable, (List<Object>)ImmutableList.of()));
                    continue;
                }
                assignments.add((Object)this.getAssignment(name, (ApplicationTerm)variable));
                continue;
            }
            assignments.addAll(this.getUFAssignments(symbol));
        }
        return assignments.build().asList();
    }

    private static String unescape(String s) {
        return s.startsWith("|") ? s.substring(1, s.length() - 1) : s;
    }

    private Collection<Model.ValueAssignment> getArrayAssignment(String symbol, Term key, Term array, List<Object> upperIndices) {
        assert (array.getSort().isArraySort());
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        Term evaluation = this.model.evaluate(array);
        while (evaluation instanceof ApplicationTerm) {
            ApplicationTerm arrayEval = (ApplicationTerm)evaluation;
            FunctionSymbol funcDecl = arrayEval.getFunction();
            Term[] params = arrayEval.getParameters();
            if (!funcDecl.isIntern() || !"store".equals(funcDecl.getName())) break;
            Term index = params[1];
            Term content = params[2];
            ArrayList<Object> innerIndices = new ArrayList<Object>(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            Term select = this.env.term("select", new Term[]{key, index});
            if (content.getSort().isArraySort()) {
                assignments.addAll(this.getArrayAssignment(symbol, select, content, innerIndices));
            } else {
                assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(this.model.evaluate(content)), this.creator.encapsulateBoolean(this.env.term("=", new Term[]{select, content})), symbol, this.evaluateImpl(content), innerIndices));
            }
            evaluation = params[0];
        }
        return assignments;
    }

    private Collection<Model.ValueAssignment> getUFAssignments(FunctionSymbol symbol) {
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        String name = SmtInterpolModel.unescape(symbol.getApplicationString());
        de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model mmodel = (de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model)this.model;
        for (FunctionValue.Index key : mmodel.getFunctionValue(symbol).values().keySet()) {
            assignments.add(this.getAssignment(name, (ApplicationTerm)this.env.term(name, key.toArray())));
        }
        return assignments;
    }

    private Model.ValueAssignment getAssignment(String key, ApplicationTerm term) {
        Term value = this.model.evaluate((Term)term);
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (Term param : term.getParameters()) {
            argumentInterpretation.add(this.evaluateImpl(param));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(term), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(this.env.term("=", new Term[]{term, value})), key, this.evaluateImpl(term), argumentInterpretation);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    @Override
    public void close() {
    }

    @Override
    protected Term evalImpl(Term formula) {
        return this.model.evaluate(formula);
    }
}

