/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public interface BooleanFormulaManager {
    default public BooleanFormula makeBoolean(boolean value) {
        return value ? this.makeTrue() : this.makeFalse();
    }

    public BooleanFormula makeTrue();

    public BooleanFormula makeFalse();

    public BooleanFormula makeVariable(String var1);

    public BooleanFormula equivalence(BooleanFormula var1, BooleanFormula var2);

    public BooleanFormula implication(BooleanFormula var1, BooleanFormula var2);

    public boolean isTrue(BooleanFormula var1);

    public boolean isFalse(BooleanFormula var1);

    public <T extends Formula> T ifThenElse(BooleanFormula var1, T var2, T var3);

    public BooleanFormula not(BooleanFormula var1);

    public BooleanFormula and(BooleanFormula var1, BooleanFormula var2);

    public BooleanFormula and(Collection<BooleanFormula> var1);

    public BooleanFormula and(BooleanFormula ... var1);

    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction();

    public BooleanFormula or(BooleanFormula var1, BooleanFormula var2);

    public BooleanFormula or(Collection<BooleanFormula> var1);

    public BooleanFormula or(BooleanFormula ... var1);

    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction();

    public BooleanFormula xor(BooleanFormula var1, BooleanFormula var2);

    @CanIgnoreReturnValue
    public <R> R visit(BooleanFormula var1, BooleanFormulaVisitor<R> var2);

    public void visitRecursively(BooleanFormula var1, BooleanFormulaVisitor<TraversalProcess> var2);

    public BooleanFormula transformRecursively(BooleanFormula var1, BooleanFormulaTransformationVisitor var2);

    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula var1, boolean var2);

    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula var1, boolean var2);
}

