/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractEvaluator<TFormulaInfo, TType, TEnv>
implements Evaluator {
    private final AbstractProver<?> prover;
    protected final FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator;
    private boolean closed = false;

    protected AbstractEvaluator(AbstractProver<?> pProver, FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator) {
        this.prover = pProver;
        this.creator = creator;
    }

    @Override
    public final <T extends Formula> @Nullable T eval(T f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        TFormulaInfo evaluation = this.evalImpl(this.creator.extractInfo(f));
        return (T)(evaluation == null ? null : this.creator.encapsulateWithTypeOf(evaluation));
    }

    @Override
    public final @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula f) {
        Object value = this.evaluateImpl(this.creator.extractInfo(f));
        if (value instanceof BigInteger) {
            return Rational.ofBigInteger((BigInteger)((BigInteger)value));
        }
        return (Rational)value;
    }

    @Override
    public final @Nullable Boolean evaluate(BooleanFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return (Boolean)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public final @Nullable String evaluate(StringFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return (String)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public final @Nullable String evaluate(EnumerationFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return (String)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public final @Nullable BigInteger evaluate(BitvectorFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public final @Nullable Object evaluate(Formula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((!(f instanceof ArrayFormula) ? 1 : 0) != 0, (Object)"cannot compute a simple constant evaluation for an array-formula");
        return this.evaluateImpl(this.creator.extractInfo(f));
    }

    protected abstract @Nullable TFormulaInfo evalImpl(TFormulaInfo var1);

    protected final @Nullable Object evaluateImpl(TFormulaInfo f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        TFormulaInfo evaluatedF = this.evalImpl(f);
        return evaluatedF == null ? null : this.creator.convertValue(f, evaluatedF);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.prover != null) {
            this.prover.unregisterEvaluator(this);
        }
        this.closed = true;
    }
}

