/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5ArrayFormulaManager
extends AbstractArrayFormulaManager<Term, Sort, Solver, Term> {
    private final Solver solver;

    public CVC5ArrayFormulaManager(CVC5FormulaCreator pFormulaCreator) {
        super(pFormulaCreator);
        this.solver = (Solver)pFormulaCreator.getEnv();
    }

    @Override
    protected Term select(Term pArray, Term pIndex) {
        return this.solver.mkTerm(Kind.SELECT, pArray, pIndex);
    }

    @Override
    protected Term store(Term pArray, Term pIndex, Term pValue) {
        return this.solver.mkTerm(Kind.STORE, pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Sort cvc5ArrayType = (Sort)this.toSolverType(arrayFormulaType);
        return (Term)this.getFormulaCreator().makeVariable(cvc5ArrayType, pName);
    }

    @Override
    protected Term equivalence(Term pArray1, Term pArray2) {
        return this.solver.mkTerm(Kind.EQUAL, pArray1, pArray2);
    }
}

