/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5EnumerationFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Formula;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5QuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5SLFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5StringFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5UFManager;

class CVC5FormulaManager
extends AbstractFormulaManager<Term, Sort, Solver, Term> {
    private final CVC5FormulaCreator creator;

    CVC5FormulaManager(CVC5FormulaCreator pFormulaCreator, CVC5UFManager pFfmgr, CVC5BooleanFormulaManager pBfmgr, CVC5IntegerFormulaManager pIfmgr, CVC5RationalFormulaManager pRfmgr, CVC5BitvectorFormulaManager pBvfmgr, CVC5FloatingPointFormulaManager pFpfmgr, CVC5QuantifiedFormulaManager pQfmgr, CVC5ArrayFormulaManager pAfmgr, CVC5SLFormulaManager pSLfmgr, CVC5StringFormulaManager pStrmgr, CVC5EnumerationFormulaManager pEfmgr) {
        super(pFormulaCreator, pFfmgr, pBfmgr, pIfmgr, pRfmgr, pBvfmgr, pFpfmgr, pQfmgr, pAfmgr, pSLfmgr, pStrmgr, pEfmgr);
        this.creator = pFormulaCreator;
    }

    static Term getCVC5Term(Formula pT) {
        if (pT instanceof CVC5Formula) {
            return ((CVC5Formula)pT).getTerm();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Appender dumpFormula(final Term f) {
        assert (this.getFormulaCreator().getFormulaType(f) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                LinkedHashMap allVars = new LinkedHashMap();
                CVC5FormulaManager.this.creator.extractVariablesAndUFs(f, true, allVars::put);
                for (Map.Entry entry : allVars.entrySet()) {
                    Iterable childrenTypes;
                    String name = (String)entry.getKey();
                    Term var = (Term)entry.getValue();
                    out.append("(declare-fun ").append(PrintTerm.quoteIdentifier((String)name)).append(" (");
                    try {
                        childrenTypes = var.getSort().isFunction() || var.getKind() == Kind.APPLY_UF ? Iterables.skip((Iterable)Iterables.transform((Iterable)var, Term::getSort), (int)1) : Iterables.transform((Iterable)var, Term::getSort);
                    }
                    catch (CVC5ApiException e) {
                        childrenTypes = Iterables.transform((Iterable)var, Term::getSort);
                    }
                    out.append(Joiner.on((String)" ").join(childrenTypes));
                    out.append(") ").append(var.getSort().toString()).append(")\n");
                }
                out.append("(assert ");
                out.append(f.toString());
                out.append(')');
            }
        };
    }

    @Override
    public <T extends Formula> T substitute(T f, Map<? extends Formula, ? extends Formula> fromToMapping) {
        Term[] changeFrom = new Term[fromToMapping.size()];
        Term[] changeTo = new Term[fromToMapping.size()];
        int idx = 0;
        for (Map.Entry<? extends Formula, ? extends Formula> e : fromToMapping.entrySet()) {
            changeFrom[idx] = (Term)this.extractInfo(e.getKey());
            changeTo[idx] = (Term)this.extractInfo(e.getValue());
            ++idx;
        }
        Term input = (Term)this.extractInfo(f);
        FormulaType<T> type = this.getFormulaType(f);
        return this.getFormulaCreator().encapsulate(type, input.substitute(changeFrom, changeTo));
    }
}

