/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5IntegerFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Mathsat5IntegerFormulaManager(Mathsat5FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return (Long)this.decimalAsInteger(pNumber);
    }

    private long ceil(long t) {
        long minusOne = Mathsat5NativeApi.msat_make_number(this.mathsatEnv, "-1");
        return Mathsat5NativeApi.msat_make_times(this.mathsatEnv, Mathsat5NativeApi.msat_make_floor(this.mathsatEnv, Mathsat5NativeApi.msat_make_times(this.mathsatEnv, t, minusOne)), minusOne);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        long div = Mathsat5NativeApi.msat_make_divide(this.mathsatEnv, pNumber1, pNumber2);
        return Mathsat5NativeApi.msat_make_term_ite(this.mathsatEnv, Mathsat5NativeApi.msat_make_leq(this.mathsatEnv, pNumber2, Mathsat5NativeApi.msat_make_int_number(this.mathsatEnv, 0)), this.ceil(div), Mathsat5NativeApi.msat_make_floor(this.mathsatEnv, div));
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, BigInteger pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, pModulo.toString());
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, Long.toString(pModulo));
    }

    protected Long modularCongruence0(Long pNumber1, Long pNumber2, String pModulo) {
        return Mathsat5NativeApi.msat_make_int_modular_congruence(this.mathsatEnv, pModulo, pNumber1, pNumber2);
    }
}

