/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

class Mathsat5InterpolatingProver
extends Mathsat5AbstractProver<Integer>
implements InterpolatingProverEnvironment<Integer> {
    private static final ImmutableSet<String> ALLOWED_FAILURE_MESSAGES = ImmutableSet.of((Object)"Unexpected proof rule to split: PN4msat5proof5ProofE", (Object)"impossible to build a suitable congruence graph!", (Object)"can't build ie-local interpolant", (Object)"set_raised on an already-raised proof", (Object)"splitting of AB-mixed terms not supported", (Object)"Hypothesis belongs neither to A nor to B", (Object[])new String[]{"FP<->BV combination unsupported by the current configuration", "cur_eq unknown to the classifier", "unknown constraint in the ItpMapper", "AB-mixed term not found in eq_itp map", "uncolored atom found in Array proof", "uncolorable Array proof", "arr: proof splitting not supported", "AB-mixed term in LaHyp", "AB-mixed term in LaCombImp"});
    private static final ImmutableSet<String> ALLOWED_FAILURE_MESSAGE_PREFIXES = ImmutableSet.of((Object)"uncolorable NA lemma");

    Mathsat5InterpolatingProver(Mathsat5SolverContext pMgr, ShutdownNotifier pShutdownNotifier, Mathsat5FormulaCreator creator, Set<SolverContext.ProverOptions> options) {
        super(pMgr, options, creator, pShutdownNotifier);
    }

    @Override
    protected void createConfig(Map<String, String> pConfig) {
        pConfig.put("interpolation", "true");
        pConfig.put("model_generation", "true");
        pConfig.put("theory.bv.eager", "false");
    }

    @Override
    protected Integer addConstraintImpl(BooleanFormula f) throws InterruptedException {
        this.closeAllEvaluators();
        int group = Mathsat5NativeApi.msat_create_itp_group(this.curEnv);
        Mathsat5NativeApi.msat_set_itp_group(this.curEnv, group);
        long t = this.creator.extractInfo(f);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, t);
        return group;
    }

    @Override
    protected long getMsatModel() throws SolverException {
        try {
            return super.getMsatModel();
        }
        catch (IllegalArgumentException e) {
            String msg = Strings.emptyToNull((String)e.getMessage());
            throw new SolverException("msat_get_model failed" + (String)(msg != null ? " with \"" + msg + "\"" : "") + ", probably the actual problem is interpolation", e);
        }
    }

    @Override
    public BooleanFormula getInterpolant(Collection<Integer> formulasOfA) throws SolverException {
        long itp;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getAssertedConstraintIds().containsAll(formulasOfA), (Object)"interpolation can only be done over previously asserted formulas.");
        int[] groupsOfA = Ints.toArray(formulasOfA);
        try {
            itp = Mathsat5NativeApi.msat_get_interpolant(this.curEnv, groupsOfA);
        }
        catch (IllegalArgumentException e) {
            block4: {
                String message;
                block5: {
                    message = e.getMessage();
                    if (Strings.isNullOrEmpty((String)message)) break block4;
                    if (ALLOWED_FAILURE_MESSAGES.contains((Object)message)) break block5;
                    if (!ALLOWED_FAILURE_MESSAGE_PREFIXES.stream().anyMatch(message::startsWith)) break block4;
                }
                throw new SolverException(message, e);
            }
            throw e;
        }
        return this.creator.encapsulateBoolean(itp);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<Integer>> partitionedFormulas) throws SolverException {
        Preconditions.checkArgument((!partitionedFormulas.isEmpty() ? 1 : 0) != 0, (Object)"at least one partition should be available.");
        ImmutableSet assertedConstraintIds = this.getAssertedConstraintIds();
        Preconditions.checkArgument((boolean)partitionedFormulas.stream().allMatch(arg_0 -> assertedConstraintIds.containsAll(arg_0)), (Object)"interpolation can only be done over previously asserted formulas.");
        ArrayList<BooleanFormula> itps = new ArrayList<BooleanFormula>();
        for (int i = 1; i < partitionedFormulas.size(); ++i) {
            itps.add(this.getInterpolant((Collection<Integer>)ImmutableList.copyOf((Iterable)Iterables.concat(partitionedFormulas.subList(0, i)))));
        }
        return itps;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<Integer>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("directly receiving tree interpolants is not supported.Use another solver or another strategy for interpolants.");
    }

    @Override
    public <T> T allSat(BasicProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) {
        throw new UnsupportedOperationException("allsat computation is not possible with interpolation prover.");
    }
}

