/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import java.util.Collection;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;

public class OpenSmtBooleanFormulaManager
extends AbstractBooleanFormulaManager<PTRef, SRef, Logic, SymRef> {
    private final Logic logic;
    private final PTRef openSmtTrue;
    private final PTRef openSmtFalse;

    OpenSmtBooleanFormulaManager(OpenSmtFormulaCreator pCreator) {
        super(pCreator);
        this.logic = (Logic)pCreator.getEnv();
        this.openSmtTrue = this.logic.getTerm_true();
        this.openSmtFalse = this.logic.getTerm_false();
    }

    @Override
    protected PTRef and(PTRef pParam1, PTRef pParam2) {
        return this.logic.mkAnd(pParam1, pParam2);
    }

    @Override
    protected PTRef andImpl(Collection<PTRef> pParams) {
        return this.logic.mkAnd(new VectorPTRef(pParams));
    }

    @Override
    protected PTRef equivalence(PTRef bits1, PTRef bits2) {
        return this.logic.mkEq(bits1, bits2);
    }

    @Override
    protected PTRef ifThenElse(PTRef pCond, PTRef pF1, PTRef pF2) {
        if (this.isTrue(pCond)) {
            return pF1;
        }
        if (this.isFalse(pCond)) {
            return pF2;
        }
        if (pF1.equals((Object)pF2)) {
            return pF1;
        }
        if (this.isTrue(pF1) && this.isFalse(pF2)) {
            return pCond;
        }
        if (this.isFalse(pF1) && this.isTrue(pF2)) {
            return this.not(pCond);
        }
        return this.logic.mkIte(pCond, pF1, pF2);
    }

    @Override
    protected boolean isFalse(PTRef bits) {
        return this.logic.isFalse(bits);
    }

    @Override
    protected boolean isTrue(PTRef bits) {
        return this.logic.isTrue(bits);
    }

    @Override
    protected PTRef makeBooleanImpl(boolean value) {
        return value ? this.openSmtTrue : this.openSmtFalse;
    }

    @Override
    protected PTRef makeVariableImpl(String pVar) {
        return this.logic.mkBoolVar(pVar);
    }

    @Override
    protected PTRef not(PTRef pParam1) {
        return this.logic.mkNot(pParam1);
    }

    @Override
    protected PTRef or(PTRef pParam1, PTRef pParam2) {
        return this.logic.mkOr(pParam1, pParam2);
    }

    @Override
    protected PTRef orImpl(Collection<PTRef> pParams) {
        return this.logic.mkOr(new VectorPTRef(pParams));
    }

    @Override
    protected PTRef xor(PTRef pParam1, PTRef pParam2) {
        return this.logic.mkXor(pParam1, pParam2);
    }
}

