/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.theories.nia.GroebnerMultiplication;
import ap.types.Sort;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessNumeralFormulaManager;

class PrincessIntegerFormulaManager
extends PrincessNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    PrincessIntegerFormulaManager(PrincessFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected ITerm makeNumberImpl(long i) {
        return new IIntLit(IdealInt.apply((long)i));
    }

    @Override
    protected ITerm makeNumberImpl(BigInteger pI) {
        return new IIntLit(IdealInt.apply((String)pI.toString()));
    }

    @Override
    protected ITerm makeNumberImpl(String pI) {
        return new IIntLit(IdealInt.apply((String)pI));
    }

    @Override
    protected ITerm makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected IExpression makeNumberImpl(BigDecimal pNumber) {
        return (IExpression)this.decimalAsInteger(pNumber);
    }

    @Override
    protected IExpression makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getIntegerType();
        return (IExpression)this.getFormulaCreator().makeVariable(t, varName);
    }

    @Override
    protected IExpression modularCongruence(IExpression pNumber1, IExpression pNumber2, long pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, this.makeNumberImpl(pModulo));
    }

    @Override
    protected IExpression modularCongruence(IExpression pNumber1, IExpression pNumber2, BigInteger pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, this.makeNumberImpl(pModulo));
    }

    private IExpression modularCongruence0(IExpression pNumber1, IExpression pNumber2, ITerm n) {
        ITerm diff = this.subtract(pNumber1, pNumber2);
        ITerm sum = this.add((IExpression)diff, this.multiply((IExpression)IExpression.v((int)0), (IExpression)n));
        return IExpression.ex((IFormula)IExpression.eqZero((ITerm)sum));
    }

    @Override
    public IExpression divide(IExpression pNumber1, IExpression pNumber2) {
        return GroebnerMultiplication.eDivWithSpecialZero((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
    }

    @Override
    public IExpression modulo(IExpression pNumber1, IExpression pNumber2) {
        return GroebnerMultiplication.eModWithSpecialZero((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
    }

    @Override
    public IExpression multiply(IExpression pNumber1, IExpression pNumber2) {
        return GroebnerMultiplication.mult((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
    }

    @Override
    protected boolean isNumeral(IExpression val) {
        return val instanceof IIntLit;
    }
}

