/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

abstract class Z3NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Long, Long, Long, ParamFormulaType, ResultFormulaType, Long> {
    protected final long z3context;

    Z3NumeralFormulaManager(Z3FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.z3context = (Long)pCreator.getEnv();
    }

    protected abstract long getNumeralType();

    @Override
    protected boolean isNumeral(Long val) {
        return Native.isNumeralAst((long)this.z3context, (long)val);
    }

    @Override
    protected Long makeNumberImpl(long i) {
        long sort = this.getNumeralType();
        return Native.mkInt64((long)this.z3context, (long)i, (long)sort);
    }

    @Override
    protected Long makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Long makeNumberImpl(String pI) {
        long sort = this.getNumeralType();
        return Native.mkNumeral((long)this.z3context, (String)pI, (long)sort);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = this.getNumeralType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long negate(Long pNumber) {
        long sort = Native.getSort((long)this.z3context, (long)pNumber);
        long minusOne = Native.mkInt((long)this.z3context, (int)-1, (long)sort);
        return Native.mkMul((long)this.z3context, (int)2, (long[])new long[]{minusOne, pNumber});
    }

    @Override
    protected Long add(Long pNumber1, Long pNumber2) {
        return Native.mkAdd((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    protected Long sumImpl(List<Long> operands) {
        return Native.mkAdd((long)this.z3context, (int)operands.size(), (long[])Longs.toArray(operands));
    }

    @Override
    protected Long subtract(Long pNumber1, Long pNumber2) {
        return Native.mkSub((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    protected Long divide(Long pNumber1, Long pNumber2) {
        return Native.mkDiv((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long multiply(Long pNumber1, Long pNumber2) {
        return Native.mkMul((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    protected Long equal(Long pNumber1, Long pNumber2) {
        return Native.mkEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long distinctImpl(List<Long> pNumbers) {
        return Native.mkDistinct((long)this.z3context, (int)pNumbers.size(), (long[])Longs.toArray(pNumbers));
    }

    @Override
    protected Long greaterThan(Long pNumber1, Long pNumber2) {
        return Native.mkGt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkGe((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long lessThan(Long pNumber1, Long pNumber2) {
        return Native.mkLt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkLe((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }
}

