/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

public interface BitvectorFormulaManager {
    public BitvectorFormula makeBitvector(int var1, long var2);

    public BitvectorFormula makeBitvector(int var1, BigInteger var2);

    public BitvectorFormula makeBitvector(int var1, NumeralFormula.IntegerFormula var2);

    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula var1, boolean var2);

    public BitvectorFormula makeVariable(int var1, String var2);

    public BitvectorFormula makeVariable(FormulaType.BitvectorType var1, String var2);

    public int getLength(BitvectorFormula var1);

    public BitvectorFormula negate(BitvectorFormula var1);

    public BitvectorFormula add(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula subtract(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula divide(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    @Deprecated(forRemoval=true)
    default public BitvectorFormula modulo(BitvectorFormula dividend, BitvectorFormula divisor, boolean signed) {
        return this.remainder(dividend, divisor, signed);
    }

    public BitvectorFormula smodulo(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula remainder(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BitvectorFormula multiply(BitvectorFormula var1, BitvectorFormula var2);

    public BooleanFormula equal(BitvectorFormula var1, BitvectorFormula var2);

    public BooleanFormula greaterThan(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BooleanFormula greaterOrEquals(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BooleanFormula lessThan(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BooleanFormula lessOrEquals(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BitvectorFormula not(BitvectorFormula var1);

    public BitvectorFormula and(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula or(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula xor(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula shiftRight(BitvectorFormula var1, BitvectorFormula var2, boolean var3);

    public BitvectorFormula shiftLeft(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula rotateLeft(BitvectorFormula var1, int var2);

    public BitvectorFormula rotateLeft(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula rotateRight(BitvectorFormula var1, int var2);

    public BitvectorFormula rotateRight(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula concat(BitvectorFormula var1, BitvectorFormula var2);

    public BitvectorFormula extract(BitvectorFormula var1, int var2, int var3);

    public BitvectorFormula extend(BitvectorFormula var1, int var2, boolean var3);

    public BooleanFormula distinct(List<BitvectorFormula> var1);
}

