/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;

public final class ShutdownHook
implements ShutdownNotifier.ShutdownRequestListener,
AutoCloseable {
    private final ShutdownNotifier shutdownNotifier;
    private final Runnable interruptCall;
    final AtomicBoolean isActiveHook = new AtomicBoolean(true);

    public ShutdownHook(ShutdownNotifier pShutdownNotifier, Runnable pInterruptCall) {
        this.interruptCall = (Runnable)Preconditions.checkNotNull((Object)pInterruptCall);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.shutdownNotifier.register((ShutdownNotifier.ShutdownRequestListener)this);
    }

    public void shutdownRequested(@Nullable String reasonUnused) {
        while (this.isActiveHook.get()) {
            this.interruptCall.run();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void close() {
        this.isActiveHook.set(false);
        this.shutdownNotifier.unregister((ShutdownNotifier.ShutdownRequestListener)this);
    }
}

