/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingSolverInformation;

class DebuggingAssertions {
    private final FormulaManager formulaManager;
    private final DebuggingSolverInformation debugInfo;

    DebuggingAssertions(SolverContextFactory.Solvers pSolver, Configuration pConfiguration, FormulaManager pFormulaManager) throws InvalidConfigurationException {
        this.debugInfo = new DebuggingSolverInformation(pSolver, pConfiguration);
        this.formulaManager = pFormulaManager;
    }

    public void assertThreadLocal() {
        if (this.debugInfo.isThreadLocal()) {
            Thread currentThread = Thread.currentThread();
            Thread initialThread = this.debugInfo.getInitialSolverContextThread();
            Preconditions.checkState((boolean)currentThread.equals(initialThread), (String)"Solver instance was not created on this thread. This is thread %s, but the solver instance belongs to thread %s.", (Object)currentThread.getName(), (Object)initialThread.getName());
        }
    }

    public void addFunctionDeclaration(FunctionDeclaration<?> pFunctionDeclaration) {
        this.debugInfo.getDeclaredFunctions().add(pFunctionDeclaration);
    }

    public void assertDeclarationInContext(FunctionDeclaration<?> pFunctionDeclaration) {
        if (List.of(FunctionDeclarationKind.VAR, FunctionDeclarationKind.UF).contains((Object)pFunctionDeclaration.getKind())) {
            Preconditions.checkArgument((boolean)this.debugInfo.getDeclaredFunctions().contains(pFunctionDeclaration), (String)("Function was not declared " + (this.debugInfo.isNoSharedDeclarations() ? "in this context." : "on this solver.") + "\n%s\nnot in\n%s"), pFunctionDeclaration, this.debugInfo.getDeclaredFunctions());
        }
    }

    public void addFormulaTerm(Formula pFormula) {
        this.formulaManager.visitRecursively(pFormula, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                DebuggingAssertions.this.debugInfo.getDefinedFormulas().add(f);
                return TraversalProcess.CONTINUE;
            }
        });
    }

    public void assertFormulaInContext(Formula pFormula) {
        Preconditions.checkArgument((boolean)this.debugInfo.getDefinedFormulas().contains(pFormula), (String)("Function was not declared " + (this.debugInfo.isNoSharedFormulas() ? "in this context." : "on this solver.") + "\n%s\nnot in\n%s"), (Object)pFormula, this.debugInfo.getDefinedFormulas());
    }
}

