/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.EnumerationFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.api.StringFormulaManager;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingArrayFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingBitvectorFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingBooleanFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingEnumerationFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingFloatingPointFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingIntegerFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingQuantifiedFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingRationalFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingSLFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingStringFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingUFManager;

public class DebuggingFormulaManager
implements FormulaManager {
    private final FormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingFormulaManager(FormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (FormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public IntegerFormulaManager getIntegerFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingIntegerFormulaManager(this.delegate.getIntegerFormulaManager(), this.debugging);
    }

    @Override
    public RationalFormulaManager getRationalFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingRationalFormulaManager(this.delegate.getRationalFormulaManager(), this.debugging);
    }

    @Override
    public BooleanFormulaManager getBooleanFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingBooleanFormulaManager(this.delegate.getBooleanFormulaManager(), this.debugging);
    }

    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingArrayFormulaManager(this.delegate.getArrayFormulaManager(), this.debugging);
    }

    @Override
    public BitvectorFormulaManager getBitvectorFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingBitvectorFormulaManager(this.delegate.getBitvectorFormulaManager(), this.debugging);
    }

    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingFloatingPointFormulaManager(this.delegate.getFloatingPointFormulaManager(), this.debugging);
    }

    @Override
    public UFManager getUFManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingUFManager(this.delegate.getUFManager(), this.debugging);
    }

    @Override
    public SLFormulaManager getSLFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingSLFormulaManager(this.delegate.getSLFormulaManager(), this.debugging);
    }

    @Override
    public QuantifiedFormulaManager getQuantifiedFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingQuantifiedFormulaManager(this.delegate.getQuantifiedFormulaManager(), this.debugging);
    }

    @Override
    public StringFormulaManager getStringFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingStringFormulaManager(this.delegate.getStringFormulaManager(), this.debugging);
    }

    @Override
    public EnumerationFormulaManager getEnumerationFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingEnumerationFormulaManager(this.delegate.getEnumerationFormulaManager(), this.debugging);
    }

    @Override
    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name) {
        this.debugging.assertThreadLocal();
        T result = this.delegate.makeVariable(formulaType, name);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> declaration, List<? extends Formula> args) {
        this.debugging.assertThreadLocal();
        for (Formula formula : args) {
            this.debugging.assertFormulaInContext(formula);
        }
        T result = this.delegate.makeApplication(declaration, args);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> declaration, Formula ... args) {
        this.debugging.assertThreadLocal();
        for (Formula f : args) {
            this.debugging.assertFormulaInContext(f);
        }
        T result = this.delegate.makeApplication(declaration, args);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.getFormulaType(formula);
    }

    @Override
    public BooleanFormula parse(String s) throws IllegalArgumentException {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.parse(s);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public Appender dumpFormula(final BooleanFormula pT) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pT);
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                String dumped = DebuggingFormulaManager.this.delegate.dumpFormula(pT).toString();
                out.append(dumped);
            }
        };
    }

    @Override
    public BooleanFormula applyTactic(BooleanFormula input, Tactic tactic) throws InterruptedException {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(input);
        BooleanFormula result = this.delegate.applyTactic(input, tactic);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <T extends Formula> T simplify(T input) throws InterruptedException {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(input);
        T result = this.delegate.simplify(input);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <R> R visit(Formula f, FormulaVisitor<R> rFormulaVisitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        return this.delegate.visit(f, rFormulaVisitor);
    }

    @Override
    public void visitRecursively(Formula f, FormulaVisitor<TraversalProcess> rFormulaVisitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        this.delegate.visitRecursively(f, rFormulaVisitor);
    }

    @Override
    public <T extends Formula> T transformRecursively(T f, FormulaTransformationVisitor pFormulaVisitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        return this.delegate.transformRecursively(f, pFormulaVisitor);
    }

    @Override
    public ImmutableMap<String, Formula> extractVariables(Formula f) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        return this.delegate.extractVariables(f);
    }

    @Override
    public ImmutableMap<String, Formula> extractVariablesAndUFs(Formula f) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        return this.delegate.extractVariablesAndUFs(f);
    }

    @Override
    public <T extends Formula> T substitute(T f, Map<? extends Formula, ? extends Formula> fromToMapping) {
        this.debugging.assertThreadLocal();
        ArrayList<Formula> checkAll = new ArrayList<Formula>();
        checkAll.add(f);
        checkAll.addAll(fromToMapping.keySet());
        checkAll.addAll(fromToMapping.values());
        for (Formula term : checkAll) {
            this.debugging.assertFormulaInContext(term);
        }
        T result = this.delegate.substitute(f, fromToMapping);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula translateFrom(BooleanFormula formula, FormulaManager otherManager) {
        if (otherManager instanceof DebuggingFormulaManager) {
            ((DebuggingFormulaManager)otherManager).debugging.assertFormulaInContext(formula);
        }
        BooleanFormula result = this.delegate.translateFrom(formula, otherManager);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public boolean isValidName(String variableName) {
        this.debugging.assertThreadLocal();
        return this.delegate.isValidName(variableName);
    }

    @Override
    public String escape(String variableName) {
        this.debugging.assertThreadLocal();
        return this.delegate.escape(variableName);
    }

    @Override
    public String unescape(String variableName) {
        this.debugging.assertThreadLocal();
        return this.delegate.unescape(variableName);
    }
}

