/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingBasicProverEnvironment;

public class DebuggingInterpolatingProverEnvironment<T>
extends DebuggingBasicProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final InterpolatingProverEnvironment<T> delegate;
    private final DebuggingAssertions debugging;

    public DebuggingInterpolatingProverEnvironment(InterpolatingProverEnvironment<T> pDelegate, DebuggingAssertions pDebugging) {
        super(pDelegate, pDebugging);
        this.delegate = (InterpolatingProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BooleanFormula getInterpolant(Collection<T> formulasOfA) throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.getInterpolant(formulasOfA);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<T>> partitionedFormulas) throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        List<BooleanFormula> result = this.delegate.getSeqInterpolants(partitionedFormulas);
        for (BooleanFormula t : result) {
            this.debugging.addFormulaTerm(t);
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<T>> partitionedFormulas, int[] startOfSubTree) throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        List<BooleanFormula> result = this.delegate.getTreeInterpolants(partitionedFormulas, startOfSubTree);
        for (BooleanFormula t : result) {
            this.debugging.addFormulaTerm(t);
        }
        return result;
    }
}

