/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointNumber;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingModel
implements Model {
    private final Model delegate;
    private final DebuggingAssertions debugging;

    public DebuggingModel(Model pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (Model)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public <T extends Formula> @Nullable T eval(T formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        T result = this.delegate.eval(formula);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public @Nullable Object evaluate(Formula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable Boolean evaluate(BooleanFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable BigInteger evaluate(BitvectorFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable String evaluate(StringFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable String evaluate(EnumerationFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public @Nullable FloatingPointNumber evaluate(FloatingPointFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.evaluate(formula);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        this.debugging.assertThreadLocal();
        ImmutableList<Model.ValueAssignment> result = this.delegate.asList();
        for (Model.ValueAssignment v : result) {
            this.debugging.addFormulaTerm(v.getValueAsFormula());
            this.debugging.addFormulaTerm(v.getAssignmentAsFormula());
        }
        return result;
    }

    @Override
    public void close() {
        this.debugging.assertThreadLocal();
        this.delegate.close();
    }
}

