/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingQuantifiedFormulaManager
implements QuantifiedFormulaManager {
    private final QuantifiedFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingQuantifiedFormulaManager(QuantifiedFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (QuantifiedFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BooleanFormula mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<? extends Formula> pVariables, BooleanFormula pBody) {
        this.debugging.assertThreadLocal();
        for (Formula formula : pVariables) {
            this.debugging.assertFormulaInContext(formula);
        }
        this.debugging.assertFormulaInContext(pBody);
        BooleanFormula result = this.delegate.mkQuantifier(q, pVariables, pBody);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula eliminateQuantifiers(BooleanFormula pF) throws InterruptedException, SolverException {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pF);
        BooleanFormula result = this.delegate.eliminateQuantifiers(pF);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

