/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;

@Options(prefix="solver.debugMode")
public class DebuggingSolverInformation {
    @Option(secure=true, description="Enable assertions that make sure that solver instances are only used on the thread that created them.")
    private boolean threadLocal = false;
    @Option(secure=true, description="Enable assertions that make sure that functions are only used in the context that declared them.")
    private boolean noSharedDeclarations = false;
    @Option(secure=true, description="Enable assertions that make sure formula terms are only used in the context that created them.")
    private boolean noSharedFormulas = false;
    private static final Map<SolverContextFactory.Solvers, Set<FunctionDeclaration<?>>> globalFunctions = Map.of(SolverContextFactory.Solvers.PRINCESS, ConcurrentHashMap.newKeySet(), SolverContextFactory.Solvers.CVC5, ConcurrentHashMap.newKeySet(), SolverContextFactory.Solvers.YICES2, ConcurrentHashMap.newKeySet());
    private final Set<FunctionDeclaration<?>> declaredFunctions;
    private static final Map<SolverContextFactory.Solvers, Set<Formula>> globalTerms = Map.of(SolverContextFactory.Solvers.CVC4, ConcurrentHashMap.newKeySet(), SolverContextFactory.Solvers.CVC5, ConcurrentHashMap.newKeySet(), SolverContextFactory.Solvers.YICES2, ConcurrentHashMap.newKeySet());
    private Set<Formula> definedFormulas;
    private final Thread solverThread = Thread.currentThread();

    DebuggingSolverInformation(SolverContextFactory.Solvers pSolver, Configuration pConfiguration) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        if (pSolver == SolverContextFactory.Solvers.CVC5) {
            this.threadLocal = true;
        }
        if (!globalFunctions.containsKey((Object)pSolver)) {
            this.noSharedDeclarations = true;
        }
        if (!globalTerms.containsKey((Object)pSolver)) {
            this.noSharedFormulas = true;
        }
        this.declaredFunctions = this.noSharedDeclarations ? ConcurrentHashMap.newKeySet() : (Set)globalFunctions.getOrDefault((Object)pSolver, ConcurrentHashMap.newKeySet());
        this.definedFormulas = this.noSharedFormulas ? ConcurrentHashMap.newKeySet() : (Set)globalTerms.getOrDefault((Object)pSolver, ConcurrentHashMap.newKeySet());
    }

    Thread getInitialSolverContextThread() {
        return this.solverThread;
    }

    boolean isThreadLocal() {
        return this.threadLocal;
    }

    boolean isNoSharedDeclarations() {
        return this.noSharedDeclarations;
    }

    boolean isNoSharedFormulas() {
        return this.noSharedFormulas;
    }

    public static Set<Formula> getGlobalTermsForSolver(SolverContextFactory.Solvers solver) {
        return globalTerms.getOrDefault((Object)solver, ConcurrentHashMap.newKeySet());
    }

    public static boolean solverHasSharedFormulas(SolverContextFactory.Solvers solver) {
        return globalTerms.containsKey((Object)solver);
    }

    public static Set<FunctionDeclaration<?>> getGlobalFunctionsForSolver(SolverContextFactory.Solvers solver) {
        return globalFunctions.getOrDefault((Object)solver, ConcurrentHashMap.newKeySet());
    }

    public static boolean solverHasSharedFunctions(SolverContextFactory.Solvers solver) {
        return globalFunctions.containsKey((Object)solver);
    }

    public void addFunctionDeclaration(FunctionDeclaration<?> pFunctionDeclaration) {
        this.declaredFunctions.add(pFunctionDeclaration);
    }

    Set<FunctionDeclaration<?>> getDeclaredFunctions() {
        return this.declaredFunctions;
    }

    void addDefinedFormula(Formula f) {
        this.definedFormulas.add(f);
    }

    Set<Formula> getDefinedFormulas() {
        return this.definedFormulas;
    }
}

