/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingUFManager
implements UFManager {
    private final UFManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingUFManager(UFManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (UFManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public <T extends Formula> FunctionDeclaration<T> declareUF(String name, FormulaType<T> returnType, List<FormulaType<?>> args) {
        this.debugging.assertThreadLocal();
        FunctionDeclaration<T> result = this.delegate.declareUF(name, returnType, args);
        this.debugging.addFunctionDeclaration(result);
        return result;
    }

    @Override
    public <T extends Formula> FunctionDeclaration<T> declareUF(String name, FormulaType<T> returnType, FormulaType<?> ... args) {
        this.debugging.assertThreadLocal();
        FunctionDeclaration<T> result = this.delegate.declareUF(name, returnType, args);
        this.debugging.addFunctionDeclaration(result);
        return result;
    }

    @Override
    public <T extends Formula> T callUF(FunctionDeclaration<T> funcType, List<? extends Formula> args) {
        this.debugging.assertThreadLocal();
        this.debugging.assertDeclarationInContext(funcType);
        for (Formula formula : args) {
            this.debugging.assertFormulaInContext(formula);
        }
        T result = this.delegate.callUF(funcType, args);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T callUF(FunctionDeclaration<T> funcType, Formula ... args) {
        this.debugging.assertThreadLocal();
        this.debugging.assertDeclarationInContext(funcType);
        for (Formula t : args) {
            this.debugging.assertFormulaInContext(t);
        }
        T result = this.delegate.callUF(funcType, args);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        this.debugging.assertThreadLocal();
        for (Formula t : pArgs) {
            this.debugging.assertFormulaInContext(t);
        }
        T result = this.delegate.declareAndCallUF(name, pReturnType, pArgs);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, Formula ... pArgs) {
        this.debugging.assertThreadLocal();
        for (Formula t : pArgs) {
            this.debugging.assertFormulaInContext(t);
        }
        T result = this.delegate.declareAndCallUF(name, pReturnType, pArgs);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }
}

