/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointNumber;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.StringFormula;

class SynchronizedModel
implements Model {
    private final Model delegate;
    private final SolverContext sync;

    SynchronizedModel(Model pDelegate, SolverContext pSync) {
        this.delegate = (Model)Preconditions.checkNotNull((Object)pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> @Nullable T eval(T pFormula) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.eval(pFormula);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Object evaluate(Formula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Boolean evaluate(BooleanFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BigInteger evaluate(BitvectorFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable String evaluate(StringFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable String evaluate(EnumerationFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FloatingPointNumber evaluate(FloatingPointFormula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.evaluate(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.asList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.close();
        }
    }
}

