/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.PropagatorBackend;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractUserPropagator;

public class SimpleUserPropagator {
    private SimpleUserPropagator() {
    }

    public static void main(String[] args) throws InvalidConfigurationException, InterruptedException, SolverException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, SolverContextFactory.Solvers.Z3);){
            BooleanFormulaManager bmgr = context.getFormulaManager().getBooleanFormulaManager();
            SimpleUserPropagator.testWithBlockedLiterals(context, bmgr, logger);
            SimpleUserPropagator.testWithBlockedClause(context, bmgr, logger);
            SimpleUserPropagator.testWithBlockedSubclauses(context, bmgr, logger);
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Z3 is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private static void testWithBlockedLiterals(SolverContext context, BooleanFormulaManager bmgr, LogManager logger) throws InterruptedException, SolverException {
        try (ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormula p = bmgr.makeVariable("p");
            BooleanFormula q = bmgr.makeVariable("q");
            BooleanFormula r = bmgr.makeVariable("r");
            BooleanFormula s = bmgr.makeVariable("s");
            BooleanFormula clause = bmgr.or(p, q, r, s);
            prover.addConstraint(clause);
            logger.log(Level.INFO, new Object[]{"========== Checking satisfiability of", clause, "while blocking all literals =========="});
            MyUserPropagator myUserPropagator = new MyUserPropagator(logger);
            Verify.verify((boolean)prover.registerUserPropagator(myUserPropagator));
            myUserPropagator.registerExpression(p);
            myUserPropagator.registerExpression(q);
            myUserPropagator.registerExpression(r);
            myUserPropagator.registerExpression(s);
            boolean isUnsat = prover.isUnsat();
            logger.log(Level.INFO, new Object[]{"Formula", clause, "is", isUnsat ? "UNSAT" : "SAT"});
        }
    }

    private static void testWithBlockedClause(SolverContext context, BooleanFormulaManager bmgr, LogManager logger) throws InterruptedException, SolverException {
        try (ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormula p = bmgr.makeVariable("p");
            BooleanFormula q = bmgr.makeVariable("q");
            BooleanFormula r = bmgr.makeVariable("r");
            BooleanFormula s = bmgr.makeVariable("s");
            BooleanFormula clause = bmgr.or(p, q, r, s);
            prover.addConstraint(clause);
            logger.log(Level.INFO, new Object[]{"========== Checking satisfiability of", clause, "while blocking the full clause =========="});
            MyUserPropagator myUserPropagator = new MyUserPropagator(logger);
            Verify.verify((boolean)prover.registerUserPropagator(myUserPropagator));
            myUserPropagator.registerExpression(clause);
            boolean isUnsat = prover.isUnsat();
            logger.log(Level.INFO, new Object[]{"Formula", clause, "is", isUnsat ? "UNSAT" : "SAT"});
        }
    }

    private static void testWithBlockedSubclauses(SolverContext context, BooleanFormulaManager bmgr, LogManager logger) throws InterruptedException, SolverException {
        try (ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormula p = bmgr.makeVariable("p");
            BooleanFormula q = bmgr.makeVariable("q");
            BooleanFormula r = bmgr.makeVariable("r");
            BooleanFormula s = bmgr.makeVariable("s");
            BooleanFormula clause = bmgr.or(p, q, r, s);
            BooleanFormula subclause1 = bmgr.or(p, q);
            BooleanFormula subclause2 = bmgr.or(r, s);
            prover.addConstraint(clause);
            logger.log(Level.INFO, new Object[]{"========== Checking satisfiability of", clause, "while blocking the subclauses", subclause1, "and", subclause2, "=========="});
            MyUserPropagator myUserPropagator = new MyUserPropagator(logger);
            Verify.verify((boolean)prover.registerUserPropagator(myUserPropagator));
            myUserPropagator.registerExpression(subclause1);
            myUserPropagator.registerExpression(subclause2);
            boolean isUnsat = prover.isUnsat();
            logger.log(Level.INFO, new Object[]{"Formula", clause, "is", isUnsat ? "UNSAT" : "SAT"});
        }
    }

    private static class MyUserPropagator
    extends AbstractUserPropagator {
        private final List<BooleanFormula> disabledExpressions = new ArrayList<BooleanFormula>();
        private final LogManager logger;

        MyUserPropagator(LogManager logger) {
            this.logger = logger;
        }

        @Override
        public void onPush() {
            this.logger.log(Level.INFO, new Object[]{"Solver pushed"});
        }

        @Override
        public void onPop(int numPoppedLevels) {
            this.logger.log(Level.INFO, new Object[]{"Solver popped", numPoppedLevels, "levels"});
        }

        @Override
        public void onKnownValue(BooleanFormula expr, boolean value) {
            this.logger.log(Level.INFO, new Object[]{"Solver assigned", expr, "to", value});
            if (value && this.disabledExpressions.contains(expr)) {
                this.logger.log(Level.INFO, new Object[]{"User propagator raised conflict on", expr});
                this.getBackend().propagateConflict(new BooleanFormula[]{expr});
            }
        }

        @Override
        public void onDecision(BooleanFormula expr, boolean value) {
            for (BooleanFormula disExpr : this.disabledExpressions) {
                boolean decisionValue = true;
                if (!this.getBackend().propagateNextDecision(disExpr, Optional.of(true))) continue;
                this.logger.log(Level.INFO, new Object[]{String.format("User propagator overwrites decision from '%s = %s' to '%s = %s'", expr, value, disExpr, true)});
                break;
            }
        }

        @Override
        public void initializeWithBackend(PropagatorBackend backend) {
            super.initializeWithBackend(backend);
            backend.notifyOnKnownValue();
            backend.notifyOnDecision();
        }

        @Override
        public void registerExpression(BooleanFormula theoryExpr) {
            this.disabledExpressions.add(theoryExpr);
            super.registerExpression(theoryExpr);
        }
    }
}

