/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example.nqueens_user_propagator;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.example.nqueens_user_propagator.NQueensEnumeratingPropagator;

public class NQueensConstraintPropagator
extends NQueensEnumeratingPropagator {
    private final BooleanFormula[][] symbols;
    private final Map<BooleanFormula, Coordinates> symbolToCoordinates;

    public NQueensConstraintPropagator(BooleanFormula[][] symbols) {
        this.symbols = symbols;
        this.symbolToCoordinates = new HashMap<BooleanFormula, Coordinates>();
        this.fillCoordinateMap();
    }

    private void fillCoordinateMap() {
        for (int i = 0; i < this.symbols[0].length; ++i) {
            for (int j = 0; j < this.symbols[i].length; ++j) {
                this.symbolToCoordinates.put(this.symbols[i][j], new Coordinates(i, j));
            }
        }
    }

    @Override
    public void onKnownValue(BooleanFormula var, boolean value) {
        if (value) {
            Coordinates coordinates = this.symbolToCoordinates.get(var);
            for (BooleanFormula other : this.fixedVariables) {
                if (!((Boolean)this.currentModel.get(other)).booleanValue()) continue;
                Coordinates otherCoordinates = this.symbolToCoordinates.get(other);
                int x1 = coordinates.x;
                int y1 = coordinates.y;
                int x2 = otherCoordinates.x;
                int y2 = otherCoordinates.y;
                if (x1 != x2 && y1 != y2 && Math.abs(x1 - x2) != Math.abs(y1 - y2)) continue;
                this.getBackend().propagateConflict(new BooleanFormula[]{var, other});
            }
        }
        super.onKnownValue(var, value);
    }

    private static class Coordinates {
        final int x;
        final int y;

        private Coordinates(int pX, int pY) {
            this.x = pX;
            this.y = pY;
        }
    }
}

