/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.List;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFloatingPointManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormula;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaUFManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Bitwuzla;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Map_TermTerm;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Options;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Parser;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Term;

public final class BitwuzlaFormulaManager
extends AbstractFormulaManager<Term, Sort, Void, BitwuzlaDeclaration> {
    private final BitwuzlaFormulaCreator creator;
    private final Options bitwuzlaOption;

    BitwuzlaFormulaManager(BitwuzlaFormulaCreator pFormulaCreator, BitwuzlaUFManager pFunctionManager, BitwuzlaBooleanFormulaManager pBooleanManager, BitwuzlaBitvectorFormulaManager pBitvectorManager, BitwuzlaQuantifiedFormulaManager pQuantifierManager, BitwuzlaFloatingPointManager pFloatingPointManager, BitwuzlaArrayFormulaManager pArrayManager, Options pBitwuzlaOptions) {
        super(pFormulaCreator, pFunctionManager, pBooleanManager, null, null, pBitvectorManager, pFloatingPointManager, pQuantifierManager, pArrayManager, null, null, null);
        this.creator = pFormulaCreator;
        this.bitwuzlaOption = pBitwuzlaOptions;
    }

    @Override
    public BooleanFormula parse(String formulaStr) throws IllegalArgumentException {
        Sort sort;
        String s = this.stripSMTLIB2String(formulaStr);
        List<String> tokens = BitwuzlaFormulaManager.tokenize(s);
        Table<String, Sort, Term> cache = this.creator.getCache();
        ImmutableList.Builder processed = ImmutableList.builder();
        for (String string : tokens) {
            if (BitwuzlaFormulaManager.isDecl(string)) {
                Parser declParser = new Parser(this.creator.getTermManager(), this.bitwuzlaOption);
                declParser.parse(string, true, false);
                Term parsed = declParser.get_declared_funs().get(0);
                String symbol = parsed.symbol();
                if (symbol.startsWith("|") && symbol.endsWith("|")) {
                    symbol = symbol.substring(1, symbol.length() - 1);
                }
                sort = parsed.sort();
                if (cache.containsRow((Object)symbol)) {
                    if (cache.contains((Object)symbol, (Object)sort)) continue;
                    throw new IllegalArgumentException();
                }
            }
            processed.add((Object)string);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Table.Cell c : cache.cellSet()) {
            String symbol = ((Term)c.getValue()).toString();
            ImmutableList args = ImmutableList.of();
            sort = (Sort)c.getColumnKey();
            if (sort.is_fun()) {
                args = sort.fun_domain();
                sort = sort.fun_codomain();
            }
            StringBuilder decl = new StringBuilder();
            decl.append("(declare-fun").append(" ");
            decl.append(symbol).append(" ");
            decl.append("(");
            for (Sort p : args) {
                decl.append(p).append(" ");
            }
            decl.append(")").append(" ");
            decl.append(sort);
            decl.append(")");
            builder.add((Object)decl.toString());
        }
        String string = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)builder.build());
        String input = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)processed.build());
        Parser parser = new Parser(this.creator.getTermManager(), this.bitwuzlaOption);
        parser.parse(string + input, true, false);
        Vector_Term assertions = parser.bitwuzla().get_assertions();
        Preconditions.checkArgument((!assertions.isEmpty() ? 1 : 0) != 0, (String)"No assertion found in input string \"%s\"", (Object)formulaStr);
        Term result = (Term)Iterables.getLast((Iterable)assertions);
        Vector_Term declared = parser.get_declared_funs();
        Map_TermTerm subst = new Map_TermTerm();
        for (Term term : declared) {
            if (cache.containsRow((Object)term.symbol())) {
                subst.put(term, (Term)cache.get((Object)term.symbol(), (Object)term.sort()));
                continue;
            }
            cache.put((Object)term.symbol(), (Object)term.sort(), (Object)term);
        }
        result = this.creator.getTermManager().substitute_term(result, subst);
        return this.creator.encapsulateBoolean(result);
    }

    private String stripSMTLIB2String(String pFormulaStr) {
        Object s = pFormulaStr;
        int setLogicIndex = ((String)s).indexOf("(set-logic ");
        if (setLogicIndex != -1) {
            int endLogicIndex = ((String)s).indexOf(41, setLogicIndex + 1);
            String s1 = ((String)s).substring(0, setLogicIndex);
            String s2 = ((String)s).substring(endLogicIndex + 1);
            s = s1 + s2;
        }
        if (((String)s).contains("(check-sat)")) {
            s = ((String)s).replace("(check-sat)", "");
        }
        if (((String)s).contains("(exit)")) {
            s = ((String)s).replace("(exit)", "");
        }
        return s;
    }

    @Override
    public Appender dumpFormula(final Term pTerm) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                Bitwuzla bitwuzla = new Bitwuzla(BitwuzlaFormulaManager.this.creator.getTermManager());
                for (Term t : BitwuzlaFormulaManager.this.creator.getVariableCasts()) {
                    bitwuzla.assert_formula(t);
                }
                bitwuzla.assert_formula(pTerm);
                String dump = bitwuzla.print_formula();
                if (dump.startsWith("(set-logic ")) {
                    dump = dump.substring(1 + dump.indexOf(41));
                }
                dump = dump.replace("(check-sat)", "");
                dump = dump.replace("(exit)", "");
                out.append(dump);
            }
        };
    }

    static Term getBitwuzlaTerm(Formula pT) {
        return ((BitwuzlaFormula)pT).getTerm();
    }

    public static List<String> tokenize(String input) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int level = 0;
        StringBuilder read = new StringBuilder();
        boolean inComment = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (inComment) {
                if (c != '\n') continue;
                inComment = false;
                continue;
            }
            if (c == ';') {
                inComment = true;
                continue;
            }
            if (level == 0) {
                if (Character.isWhitespace(c)) continue;
                if (c == '(') {
                    read.append("(");
                    ++level;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            read.append(c);
            if (c == '(') {
                ++level;
            }
            if (c != ')') continue;
            if (level == 1) {
                builder.add((Object)read.toString());
                read = new StringBuilder();
            }
            --level;
        }
        if (level != 0) {
            throw new IllegalArgumentException();
        }
        return builder.build();
    }

    public static boolean isDecl(String token) {
        return token.matches("\\(\\s*(declare-const|declare-fun).*");
    }
}

