/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Map_TermTerm;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Int;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Term;

public class BitwuzlaQuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Term, Sort, Void, BitwuzlaDeclaration> {
    private final TermManager termManager;

    protected BitwuzlaQuantifiedFormulaManager(BitwuzlaFormulaCreator pCreator) {
        super(pCreator);
        this.termManager = pCreator.getTermManager();
    }

    @Override
    protected Term eliminateQuantifiers(Term pExtractInfo) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Bitwuzla does not support eliminating Quantifiers.");
    }

    @Override
    public Term mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<Term> vars, Term body) {
        Preconditions.checkArgument((!vars.isEmpty() ? 1 : 0) != 0, (Object)"The list of bound variables for a quantifier may not be empty.");
        Term[] origVars = new Term[vars.size()];
        Term[] substVars = new Term[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            Term boundCopy;
            Term var;
            origVars[i] = var = vars.get(i);
            substVars[i] = boundCopy = ((BitwuzlaFormulaCreator)this.formulaCreator).makeBoundVariable(var);
        }
        Map_TermTerm map = new Map_TermTerm();
        for (int i = 0; i < origVars.length; ++i) {
            map.put(origVars[i], substVars[i]);
        }
        Term currentFormula = body = this.termManager.substitute_term(body, map);
        for (int i = 0; i < vars.size(); ++i) {
            Term[] argsAndBody = new Term[]{substVars[i], currentFormula};
            currentFormula = q.equals((Object)QuantifiedFormulaManager.Quantifier.FORALL) ? this.termManager.mk_term(Kind.FORALL, new Vector_Term(argsAndBody), new Vector_Int()) : this.termManager.mk_term(Kind.EXISTS, new Vector_Term(argsAndBody), new Vector_Int());
        }
        return currentFormula;
    }
}

